﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Curse.ServiceModels.Caching;
using System.Data.SqlClient;
using System.Runtime.Serialization;

namespace Curse.DownloadStatisticService.Models
{
	[DataContract]
	public class File : ICachable
	{
		#region ICachable Members

		public int ID { get; set; }

		public void SetFromDataReader(SqlDataReader reader)
		{
			ID = reader.GetInt32(reader.GetOrdinal("ID"));
			ProjectID = reader.GetInt32(reader.GetOrdinal("ProjectID"));
			TotalDownloads = reader.GetInt32(reader.GetOrdinal("TotalDownloads"));
			HistoricCurseDownloads = reader.GetInt32(reader.GetOrdinal("HistoricCurseDownloads"));
			HistoricCurseForgeDownloads = reader.GetInt32(reader.GetOrdinal("HistoricCurseForgeDownloads"));
		}

		#endregion

		public int ProjectID { get; set; }
		public int TotalDownloads { get; set; }
		public int HistoricCurseDownloads { get; set; }
		public int HistoricCurseForgeDownloads { get; set; }
	}
}