﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Data;
using System.Configuration;
using System.Data.SqlClient;

namespace DataImporter
{
	class Program
	{
		//const int PROJECT_ID = 0;
		//const int PROJECT_GAME_ID = 1;
		//const int PROJECT_CURSE_DOWNLOADS = 2;
		//const int PROJECT_CURSEFORGE_DOWNLOADS = 3;

		const int FILE_ID = 0;
		const int FILE_PROJECT_ID = 1;
		const int FILE_CURSE_DOWNLOADS = 2;
		const int FILE_CURSEFORGE_DOWNLOADS = 3;

		static string _dbConnectionString;

		static void Main(string[] args)
		{
			_dbConnectionString = ConfigurationManager.ConnectionStrings["DownloadStatistics"].ConnectionString;

			//ImportProjectData(@"C:\temp\project-historical-downloads.csv");
			ImportFileData(@"C:\temp\file-historical-downloads.csv");
		}

		private static string[] ReadCsvFile(string fileName, bool skipHeader)
		{
			List<string> rvalue = new List<string>();
			using (var sr = new StreamReader(fileName))
			{
				rvalue.AddRange(sr.ReadToEnd().Replace("\r\n", "\n").Split('\n'));
				if (skipHeader)
				{
					rvalue.RemoveAt(0);
				}
				sr.Close();
			}

			return rvalue.ToArray();
		}

		private static int[] ConvertValues(string[] values)
		{
			int[] rvalues = new int[values.Length];
			for (int i = 0; i < values.Length; i++)
			{
				int value = 0;
				if (Int32.TryParse(values[i], out value))
				{
					rvalues[i] = value;
				}
				else rvalues[i] = 0;
			}
			return rvalues;
		}

		// HistoricDownload Coulmns where taken out of this table
		/*  private static void ImportProjectData(string fileName)
		  {
			  var projectTable = new DataTable();
			  projectTable.Columns.Add("ID", typeof(int));
			  projectTable.Columns.Add("GameID", typeof(int));
			  projectTable.Columns.Add("PopularityScore", typeof(int));
			  projectTable.Columns.Add("GamePopularityRank", typeof(int));
			  projectTable.Columns.Add("PopularityRank", typeof(int));
			  projectTable.Columns.Add("DownloadsLastThirtyDays", typeof(int));
			  projectTable.Columns.Add("TotalDownloads", typeof(int));
			  projectTable.Columns.Add("UniqueDownloadsLastThirtyDays", typeof(int));
			  projectTable.Columns.Add("DateModified", typeof(DateTime));
            
			  string[] projects = ReadCsvFile(fileName, true);
			  foreach (string project in projects)
			  {
				  if (string.IsNullOrEmpty(project)) continue;

				  int[] projectData = ConvertValues(project.Split(','));
				  projectTable.Rows.Add(projectData[PROJECT_ID], 
					  projectData[PROJECT_GAME_ID],
					  0, 0, 0, 0, 0, 0,
					  projectData[PROJECT_CURSE_DOWNLOADS], 
					  projectData[PROJECT_CURSEFORGE_DOWNLOADS], 
					  DateTime.Now);
			  }

			  using (var conn = new SqlConnection(_dbConnectionString))
			  {
				  conn.Open();
				  var trans = conn.BeginTransaction();

				  var bulkCopy = new SqlBulkCopy(conn, SqlBulkCopyOptions.KeepIdentity, trans);
				  bulkCopy.DestinationTableName = "Project";

				  try
				  {
					  bulkCopy.WriteToServer(projectTable);
					  trans.Commit();
				  }
				  catch
				  {
					  trans.Rollback();
				  }
			  }
		  } */

		private static void ImportFileData(string fileName)
		{
			var fileTable = new DataTable();
			fileTable.Columns.Add("ID", typeof(int));
			fileTable.Columns.Add("ProjectID", typeof(int));
			
			fileTable.Columns.Add("HistoricCurseDownloads", typeof(int));
			fileTable.Columns.Add("HistoricCurseForgeDownloads", typeof(int));
			

			string[] files = ReadCsvFile(fileName, true);

			foreach (string file in files)
			{
				if (string.IsNullOrEmpty(file)) continue;

				int[] fileData = ConvertValues(file.Split(','));
				fileTable.Rows.Add(fileData[FILE_ID],
					fileData[FILE_PROJECT_ID],
					fileData[FILE_CURSE_DOWNLOADS],
					fileData[FILE_CURSEFORGE_DOWNLOADS]);
			}

			using (var conn = new SqlConnection(_dbConnectionString))
			{
				conn.Open();
				using (SqlTransaction trans = conn.BeginTransaction())
				{
					//var trans = conn.BeginTransaction();
					var bulkCopy = new SqlBulkCopy(conn, SqlBulkCopyOptions.KeepIdentity, trans);
					bulkCopy.DestinationTableName = "[FileTemp]";
					bulkCopy.BulkCopyTimeout = 360;
					bulkCopy.BatchSize = 300;
					try
					{
						bulkCopy.WriteToServer(fileTable);
						trans.Commit();

					}
					catch
					{
						try
						{
							trans.Rollback();
						}
						catch (Exception Ex)
						{
							Console.WriteLine("bad stuff " + Ex.Message);
						}
					}
					conn.Close();
				}
			}

		}


	}
}
