﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Net.Mime;
using System.Runtime.Serialization;
using System.Text;
using System.Net;
using System.ServiceModel;
using System.Web;
using System.Web.Script.Serialization;
using System.Threading;
using System.Diagnostics;

namespace DownloadStatsJSONTester
{
    class Program
    {

        public static string address = @"http://downloadstats.curseforge.local/json/addDownloadLogEntries";

        public static List<string> refs = new List<string>();
        public static List<string> uas = new List<string>(); 

        static void Main(string[] args)
        {
            GenerateTestData();
            Stopwatch stopwatch = new Stopwatch();

            Messages mess = new Messages();

            int t = 0;
            int p = 1;
            stopwatch.Start();
            for (int i = 1; i <= 500000; i++)
            {
                AddDownloadLogEntryMessage m = new AddDownloadLogEntryMessage();

                Random randNum = new Random();

                string a = String.Empty;
                string b = String.Empty;

                a = refs[randNum.Next(refs.Count)];

                b = uas[randNum.Next(uas.Count)];
                

                m.ID = i;
                m.FileID = p;
                m.GameID = p;
                m.ProjectID = p;
                m.Date = System.DateTime.UtcNow.ToLongTimeString();
                m.IpAddress = "127.0.0.1";
                m.Referrer = a;
                m.UserAgent = b;

                mess.Add(m);
                t++;
                if (t == 1000)
                {
                    Send(mess);
                    t = 0;
                    p++;
                    Console.WriteLine("Sent 1000 records");
                    Thread.Sleep(3);
                }
            }
            stopwatch.Stop();
            Console.WriteLine("time took: {0}", stopwatch.Elapsed);
            Console.ReadLine();
        }

        static void c_UploadStringCompleted(object sender, UploadDataCompletedEventArgs e)
        {
            string r = "test";
        }

        private static void SendFakeErrors()
        {
            FakeMessages mess = new FakeMessages();

            int t = 0;
            for (int i = 1; i <= 1; i++)
            {
                FakeAddDownloadLogEntryMessage m = new FakeAddDownloadLogEntryMessage();

                m.ID = i;
                m.FileID = "bad";
                m.GameID = 1;
                m.ProjectID = 1;
                m.Date = System.DateTime.UtcNow.ToLongTimeString();
                m.IpAddress = "127.0.0.1";
                m.Referrer = "fake error test";
                m.UserAgent = "fake error test";

                mess.Add(m);
                Send(mess);
                Console.WriteLine("Sent fake errors records");
                Thread.Sleep(300);
            }

        }

        private static void GenerateTestData()
        {
            for (int i = 0; i <= 500000; i++)
            {
                int seed = unchecked(DateTime.Now.Ticks.GetHashCode());
                Random random = new Random(seed);
                int size = random.Next(50, 100);
                string r = RandomString(size);
                refs.Add(r);
            }


            for (int i = 0; i <= 500000; i++)
            {
                int seed = unchecked(DateTime.Now.Ticks.GetHashCode());
                Random random = new Random(seed);
                int size = random.Next(100, 300);
                string r = RandomString(size);
                uas.Add(r);
            }



        }

        private static string RandomString(int Size)
        {
            

            

            Random random2 = new Random();

            string input = "abcdefghijklmnopqrstuvwxyz0123456789";
            StringBuilder builder = new StringBuilder();
            char ch;
            for (int i = 0; i < Size; i++)
            {
                ch = input[random2.Next(0, input.Length)];
                builder.Append(ch);
            }
            return builder.ToString();
        }

        static void Send(IList mess)
        {
            var serializer = new JavaScriptSerializer();
            serializer.MaxJsonLength = Int32.MaxValue;
            var json = serializer.Serialize(mess);
            mess.Clear();
            var bytes = Encoding.UTF8.GetBytes(json);
            WebClient c = new WebClient();
            c.Headers.Add("Content-Type", "application/json");
            c.Headers.Add("Accept", "application/json");
            try
            {
                var response = c.UploadData(address, "POST", bytes);
            }
            catch (Exception)
            {
            }
            
        }
    }

    [Serializable]
    [MessageContract]
    public class AddDownloadLogEntryMessage
    {
        [MessageBodyMember(Order = 1)]
        public int ID { get; set; }

        [MessageBodyMember(Order = 2)]
        public int FileID { get; set; }

        [MessageBodyMember(Order = 3)]
        public int ProjectID { get; set; }

        [MessageBodyMember(Order = 4)]
        public int GameID { get; set; }

        [MessageBodyMember(Order = 5)]
        public string Referrer { get; set; }

        [MessageBodyMember(Order = 6)]
        public string UserAgent { get; set; }

        [MessageBodyMember(Order = 7)]
        public string Date { get; set; }

        [MessageBodyMember(Order = 8)]
        public string IpAddress { get; set; }
    }

    [Serializable]
    [CollectionDataContract]
    [KnownType(typeof(AddDownloadLogEntryMessage))]
    public class Messages : List<AddDownloadLogEntryMessage>
    {
    }


    [Serializable]
    [MessageContract]
    public class FakeAddDownloadLogEntryMessage
    {
        [MessageBodyMember(Order = 1)]
        public int ID { get; set; }

        [MessageBodyMember(Order = 2)]
        public string FileID { get; set; }

        [MessageBodyMember(Order = 3)]
        public int ProjectID { get; set; }

        [MessageBodyMember(Order = 4)]
        public int GameID { get; set; }

        [MessageBodyMember(Order = 5)]
        public string Referrer { get; set; }

        [MessageBodyMember(Order = 6)]
        public string UserAgent { get; set; }

        [MessageBodyMember(Order = 7)]
        public string Date { get; set; }

        [MessageBodyMember(Order = 8)]
        public string IpAddress { get; set; }
    }

    [Serializable]
    [CollectionDataContract]
    [KnownType(typeof(FakeAddDownloadLogEntryMessage))]
    public class FakeMessages : List<FakeAddDownloadLogEntryMessage>
    {
    }
}
