﻿using System;
using System.Collections.Generic;
using System.Linq;
using Curse.Logging;
using NetworkService.BillingService;
using System.ServiceModel;
using System.Configuration;

namespace Curse.Auth
{
    public class BillingServiceHelper
    {

        private static readonly bool _isEnabled;
        private static readonly string _endpointUrl;

        static BillingServiceHelper()
        {
            _isEnabled = bool.Parse(ConfigurationManager.AppSettings["BillingServiceEnabled"]);
            _endpointUrl = ConfigurationManager.AppSettings["BillingServiceUrl"];
        }


        /// <summary>
        /// Return an instance of the remote billing service
        /// </summary>
        /// <returns></returns>
        private static BillingServiceClient GetBillingServiceClient()
        {
            // The binding configuration
            var binding = WebServiceHelper.GetDefaultWSHttpBinding();

            // Create the client            
            return new BillingServiceClient(binding, new EndpointAddress(_endpointUrl));
        }


        public static List<UserEntitlement> GetAccountEntitlements(int accountID)
        {            
            var entitlements = new List<UserEntitlement>();
            if (!_isEnabled)
            {
                return entitlements;
            }

            try
            {
                ServiceResponseOfArrayOfAccountEntitlement response = null;
                using (var client = GetBillingServiceClient())
                {
                    response = client.GetAccountEntitlements("U-" + accountID);
                }

                if (response.Status == ServiceResponseStatus.Successful)
                {
                    entitlements.AddRange(response.Value.Select(entitlement => new UserEntitlement(entitlement)));
                }
            }
            catch (Exception ex)
            {
                Logger.Error(ex, "Failed to retreieve account entitlements!");
            }

            return entitlements;


        }        
    }
}
