﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;

namespace Curse.Auth
{

    public enum EAdminCreditUserWithRenameStatus
    {
        Unsuccessful = -1,
        Success = 1,
        UserNotFound,        
        InsufficientPermissions,
        AlreadyCredited
    }

    public enum EAdminRenameUserStatus
    {
        Unsuccessful = -1,
        Success = 1,
        UserNotFound,
        UsernameInUse,
        InvalidUsername,
        InsufficientPermissions
    }

    public enum ERenameUserStatus
    {
        Unsuccessful = -1,
        Success = 1,
        UserNotFound,
        UsernameInUse,
        InvalidUsername,
        InsufficientPermissions,
        NoRenameCredit
    }

    public enum ERenameUserDeclinedStatus
    {
        Unsuccessful = -1,
        UserNotFound,
        InsufficientPermissions,
        Success 
    }

    public enum EAdminSetUserPasswordStatus
    {
        Unsuccessful = -1,
        Success = 1,
        UserNotFound,
        InvalidPassword,
        InsufficientPermissions
    }

    public enum EUpdatePrimaryEmailStatus
    {
        Successful,
        InsufficientPermissions,
        UnknownUser,
        EmailInUse,
        InvalidEmail,
        UnknownError
    }
    
    public enum EResetPasswordStatus
    {
        Successful,
        InsufficientPermissions,
        InvalidEmail,
        UnknownEmail
    }

    public enum EAccountRecoveryStatus
    {
        Successful,        
        InsufficientPermissions,
        InvalidUsername,        
        InvalidEmail,
        InvalidPassword,
        UnknownUsername,
        UnknownEmail,
        ResetAlreadyRequested,
        NonMatchingPasswords,
        TokenNotFound,
        UnknownError        
    }

    public enum ERecoverUsernameStatus
    {
        Successful,
        InsufficientPermissions,        
        InvalidEmail,                
        UnknownEmail,        
        UnknownError
    }

    public enum EAddUserStatus
    {
        Successful,
        EmailInUse,
        UsernameInUse,
        InsufficientPermissions,
        InvalidProfile,
        InvalidUsername,
        InvalidNetworkSite,
        InvalidPassword,
        InvalidUsernameWithUnderscores
    }

    public enum ELoginStatus
    {
        Unsuccessful = -1,
        Success = 1,
        InvalidSession = 2,
        UnauthorizedLogin = 3,
        InvalidPassword = 4,
        UnknownUsername = 5,
        UnknownEmail = 6
    }

    public enum ESendActivationResult
    {
        Sent = 1000,
        AlreadyActivated = 1001,
        EmailNotFound = 1002,
        UnknownFailure = 1003
    }

    public enum ESetUserProfileResult
    {
        Unsuccessful = -1,
        Success = 1,
        EmailNotFound,
        UserNotFound,
        InvalidProfileData
    }

    public enum ESetUserProfileAndEmailResult
    {
        Unsuccessful = -1,
        Success = 1,
        EmailNotFound,
        UserNotFound,
        InvalidProfileData,
        EmailInUse,
        InvalidEmail,
        UnknownError
    }

    public enum ESetUserPasswordResult
    {
        Unsuccessful = -1,
        Success = 1,
        UserNotFound,
        InvalidPassword
    }

    public enum ESubscriptionType
    {
        Premium = 1,
        GuildHosting,
        VentriloHosting
    }

    public enum EAddNetworkSiteStatus
    {
        Successful,
        InsufficientPermissions,
        FailedValidation,
        AlreadyExists,
        UnknownError

    }

    public enum EGenericAuthenticationStatus
    {
        Successful,
        InsufficientPermissions,
        InvalidNetworkSite,
        InvalidUser,
        FailedValidation,
        Unsuccessful,
        UnknownError
    }

    public enum EAdminClearUserCacheStatus
    {
        Unsuccessful = -1,
        Success = 1,
        UserNotFound,        
        InsufficientPermissions
    }

    public enum ELegacyUserStatus
    {
        NotImported = 0,
        Failed,
        PreviouslyImported,
        Merge_Clean,
        Merge_UsernameChanged,
        NewAccount_Clean,
        NewAccount_UsernameChanged,
    }

    public enum EUserStatus
    {
        Normal = 0,
        Deleted
    }

    public enum EDeleteUserStatus
    {
        Unsuccessful = -1,
        Success = 1,
        UserNotFound,
        InsufficientPermissions,
        InvalidNetworkSite
    }

    public enum EAddSubscriptionCreditStatus
    {
        Unsuccessful = -1,
        Success = 1,
        UserNotFound,
        InvalidNetworkSite
    }

    public enum ESetPremiumExpirationStatus
    {
        Unsuccessful = -1,
        Success = 1,
        UserNotFound,
        InvalidNetworkSite
    }

    public enum EValidateEmailStatus
    {
        Unsuccessful = -1,
        Success = 1,
        InvalidNetworkSite,
        UserNotFound,
        EmailNotFound,
        InvalidActivationCode
    }

    public enum ELegacyEncryptionType
    {
        None = 0,
        MD5Password = 1,
        MD5PasswordWithSalt,
        ShaPasswordMD5Salt,
        PHPBB2,
        PHPBB3,
        vBulletin,
        IPB,
        D,
        MyBB,
        Sha1SaltWithPassword,
        Pbkdf2
    }

    public enum EoAuthDataStatus
    {
        Unsuccessful = -1,
        Success = 1,
        InvalidNetworkSite,
        UserNotFound
    }

    public enum EUpdatePolicyAcceptedStatus
    {
        Unsuccessful = -1,
        Success = 1,
        InvalidNetworkSite,
        UserNotFound
    }
}
