﻿using System;
using System.IO;
using System.Security.Cryptography;
using System.Text;

namespace Curse.Auth
{
    public class CryptoServiceProvider
    {
        static MD5 md5 = MD5.Create();
        static SHA1 sha1 = SHA1.Create();
        public static string ComputeMD5String(string inputString)
        {
            return BitConverter.ToString(md5.ComputeHash(Encoding.ASCII.GetBytes(inputString))).Replace("-", string.Empty);
        }

        public static string ComputeMD5StringWithNoEncoding(string inputString)
        {
            return BitConverter.ToString(md5.ComputeHash(GetBytes(inputString))).Replace("-", string.Empty);
        }

        public static string ComputeShaString(string inputString)
        {
            return BitConverter.ToString(sha1.ComputeHash(Encoding.ASCII.GetBytes(inputString))).Replace("-", string.Empty);
        }

        public static string ComputePBKDF2String(string pwd, string salt, int iterations)
        {
            string r = String.Empty;
            string x = String.Empty;
            string r2 = String.Empty;
            string x2 = String.Empty;
            using (RNGCryptoServiceProvider rngCsp = new RNGCryptoServiceProvider())
            {
                
                Rfc2898DeriveBytes k1 = new Rfc2898DeriveBytes(pwd, GetBytes(salt), iterations);
                byte[] key = k1.GetBytes(32);
                byte[] iv = k1.GetBytes(16);
                SHA256 sha256 = SHA256.Create();

                r = BitConverter.ToString(sha256.ComputeHash((iv)));

                x = Convert.ToBase64String(sha256.ComputeHash((iv)));


                var cipher = new RijndaelManaged { Key = key, IV = iv };

                byte[] cipherText;
                using (var encryptor = cipher.CreateEncryptor())
                {
                    using (var ms = new MemoryStream())
                    {
                        using (var cs = new CryptoStream(ms, encryptor, CryptoStreamMode.Write))
                        {
                            cs.Write(GetBytes(pwd), 0, GetBytes(pwd).Length);
                            cs.FlushFinalBlock();
                            cipherText = ms.ToArray();

                            r2 = BitConverter.ToString(sha256.ComputeHash((cipherText)));

                            x2 = Convert.ToBase64String(sha256.ComputeHash((cipherText)));

                        }
                    }
                }

            }

            return r;

        }

        public static byte[] GetBytes(string str)
        {
            byte[] bytes = new byte[str.Length * sizeof(char)];
            System.Buffer.BlockCopy(str.ToCharArray(), 0, bytes, 0, bytes.Length);
            return bytes;
        }

        public class PhpBB2
        {
            private static string encKey = "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
            public static string ComputeHash(byte[] plainTextPassword, string passwordHash)
            {
                string output = "*";
                MD5CryptoServiceProvider md5 = new MD5CryptoServiceProvider();
                if (!passwordHash.StartsWith("$P$")) return output;
                int count_log2 = encKey.IndexOf(passwordHash[3]);
                if (count_log2 < 7 || count_log2 > 30) return output;

                int count = 1 << count_log2;
                byte[] salt = ASCIIEncoding.ASCII.GetBytes(passwordHash.Substring(4, 8));

                if (salt.Length != 8) return output;

                byte[] hash = md5.ComputeHash(sCombine(salt, plainTextPassword));
                do
                {
                    hash = md5.ComputeHash(sCombine(hash, plainTextPassword));
                } while (count-- > 1);

                output = passwordHash.Substring(0, 12);
                output += EncodeHash64(hash, 16, encKey);

                return output;
            }//compute the hash from the password and hash
            private static byte[] sCombine(byte[] b1, byte[] b2)
            {
                byte[] retVal = new byte[b1.Length + b2.Length];
                Array.Copy(b1, 0, retVal, 0, b1.Length);
                Array.Copy(b2, 0, retVal, b1.Length, b2.Length);
                return retVal;
            }//Combine two byte arrays
            private static string EncodeHash64(byte[] input, int count, string itoa64)
            {
                string output = "";
                int i = 0; int value = 0;

                do
                {
                    value = input[i++];
                    output += itoa64[value & 0x3f];

                    if (i < count) value |= input[i] << 8;
                    output += itoa64[(value >> 6) & 0x3f];
                    if (i++ >= count)
                        break;

                    if (i < count) value |= input[i] << 16;
                    output += itoa64[(value >> 12) & 0x3f];
                    if (i++ >= count)
                        break;

                    output += itoa64[(value >> 18) & 0x3f];

                } while (i < count);

                return output;
            }//EncodeHash64

            /// <summary>
            /// The encryption string base.
            /// </summary>
            private string itoa64 = "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

            /// <summary>
            /// Compares the password string given with the hash retrieved from your database.
            /// </summary>
            /// <param name="password">Plaintext password.</param>
            /// <param name="hash">Hash from a SQL database</param>
            /// <returns>True if the password is correct, False otherwise.</returns>
            public bool phpbbCheckHash(string password, string hash)
            {
                if (hash.Length == 34) return (hashCryptPrivate(ASCIIEncoding.ASCII.GetBytes(password), hash, itoa64) == hash);
                return false;
            }

            /// <summary>
            /// This function will return the resulting hash from the password string you specify.
            /// </summary>
            /// <param name="password">String to hash.</param>
            /// <returns>Encrypted hash.</returns>
            /// <remarks>
            /// Although this will return the md5 for an older password, I have not added
            /// support for older passwords, so they will not work with this class unless
            /// I or someone else updates it.
            /// </remarks>
            public string phpbb_hash(string password)
            {
                // Generate a random string from a random number with the length of 6.
                // You could use a static string instead, doesn't matter. E.g.
                // byte[] random = ASCIIEncoding.ASCII.GetBytes("abc123");
                byte[] random = ASCIIEncoding.ASCII.GetBytes(new Random().Next(100000, 999999).ToString());

                string hash = hashCryptPrivate(ASCIIEncoding.ASCII.GetBytes(password), hashGensaltPrivate(random, itoa64), itoa64);

                if (hash.Length == 34) return hash;

                return sMD5(password);
            }

            /// <summary>
            /// The workhorse that encrypts your hash.
            /// </summary>
            /// <param name="password">String to be encrypted. Use: ASCIIEncoding.ASCII.GetBytes();</param>
            /// <param name="genSalt">Generated salt.</param>
            /// <param name="itoa64">The itoa64 string.</param>
            /// <returns>The encrypted hash ready to be compared.</returns>
            /// <remarks>
            /// password:  Saves conversion inside the function, lazy coding really.
            /// genSalt:   Returns from hashGensaltPrivate(random, itoa64);
            /// return:    Compare with phpbbCheckHash(password, hash)
            /// </remarks>
            private string hashCryptPrivate(byte[] password, string genSalt, string itoa64)
            {
                string output = "*";
                MD5CryptoServiceProvider md5 = new MD5CryptoServiceProvider();
                if (!genSalt.StartsWith("$P$")) return output;
                //   $count_log2 = strpos($itoa64, $setting[3]);
                int count_log2 = itoa64.IndexOf(genSalt[3]);
                if (count_log2 < 7 || count_log2 > 30) return output;

                int count = 1 << count_log2;
                byte[] salt = ASCIIEncoding.ASCII.GetBytes(genSalt.Substring(4, 8));

                if (salt.Length != 8) return output;

                byte[] hash = md5.ComputeHash(Combine(salt, password));

                do
                {
                    hash = md5.ComputeHash(Combine(hash, password));
                } while (count-- > 1);

                output = genSalt.Substring(0, 12);
                output += hashEncode64(hash, 16, itoa64);

                return output;
            }

            /// <summary>
            /// Private function to concat byte arrays.
            /// </summary>
            /// <param name="b1">Source array.</param>
            /// <param name="b2">Array to add to the source array.</param>
            /// <returns>Combined byte array.</returns>
            private byte[] Combine(byte[] b1, byte[] b2)
            {
                byte[] retVal = new byte[b1.Length + b2.Length];
                Array.Copy(b1, 0, retVal, 0, b1.Length);
                Array.Copy(b2, 0, retVal, b1.Length, b2.Length);
                return retVal;
            }

            /// <summary>
            /// Encode the hash.
            /// </summary>
            /// <param name="input">The hash to encode.</param>
            /// <param name="count">[This parameter needs documentation].</param>
            /// <param name="itoa64">The itoa64 string.</param>
            /// <returns>Encoded hash.</returns>
            private string hashEncode64(byte[] input, int count, string itoa64)
            {
                string output = "";
                int i = 0; int value = 0;

                do
                {
                    value = input[i++];
                    output += itoa64[value & 0x3f];

                    if (i < count) value |= input[i] << 8;
                    output += itoa64[(value >> 6) & 0x3f];
                    if (i++ >= count)
                        break;

                    if (i < count) value |= input[i] << 16;
                    output += itoa64[(value >> 12) & 0x3f];
                    if (i++ >= count)
                        break;

                    output += itoa64[(value >> 18) & 0x3f];

                } while (i < count);

                return output;
            }

            /// <summary>
            /// Generate salt for hash generation.
            /// </summary>
            /// <param name="input">Any random information.</param>
            /// <param name="itoa64">The itoa64 string.</param>
            /// <returns>Generated salt string</returns>
            private string hashGensaltPrivate(byte[] input, string itoa64)
            {
                int iteration_count_log2 = 6;

                string output = "$P$";
                output += itoa64[Math.Min(iteration_count_log2 + 5, 30)];
                output += hashEncode64(input, 6, itoa64);

                return output;
            }
            /// <summary>
            /// Returns a hexadecimal string representation for the encrypted MD5 parameter.
            /// </summary>
            /// <param name="password">String to be encrypted.</param>
            /// <returns>String</returns>
            private string sMD5(string password)
            { return sMD5(password, false); }
            /// <summary>
            /// Returns a hexadecimal string representation for the encrypted MD5 parameter.
            /// </summary>
            /// <param name="password">String to be encrypted.</param>
            /// <param name="raw">Whether or not to produce a raw string.</param>
            /// <returns>String</returns>
            private string sMD5(string password, bool raw)
            {
                MD5CryptoServiceProvider md5 = new MD5CryptoServiceProvider();
                if (raw) return Encoding.ASCII.GetString(md5.ComputeHash(Encoding.ASCII.GetBytes(password)));
                else return BitConverter.ToString(md5.ComputeHash(Encoding.ASCII.GetBytes(password))).Replace("-", "");
            }
        }

        /// <summary>
        /// Computes the phpBB/SubMD5 hash value for the input data using the implementation provided by http://openwall.com/phpass/ modified by http://www.phpbb.com/.
        /// </summary>
        /// <remarks>
        /// Ported by Ryan Irecki
        /// Website: http://www.digilitepc.net/
        /// E-mail: razchek@gmail.com
        /// </remarks>
        public class PhpBB3
        {
            private static string encKey = "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
            public static string ComputeHash(byte[] plainTextPassword, string passwordHash)
            {
                //string output = "*";
                //MD5CryptoServiceProvider md5 = new MD5CryptoServiceProvider();
                //if (!passwordHash.StartsWith("$P$")) return output;
                //int count_log2 = encKey.IndexOf(passwordHash[3]);
                //if (count_log2 < 7 || count_log2 > 30) return output;

                //int count = 1 << count_log2;
                //byte[] salt = ASCIIEncoding.ASCII.GetBytes(passwordHash.Substring(4, 8));

                //if (salt.Length != 8) return output;

                //byte[] hash = md5.ComputeHash(sCombine(salt, plainTextPassword));
                //do
                //{
                //    hash = md5.ComputeHash(sCombine(hash, plainTextPassword));
                //} while (count-- > 1);

                //output = passwordHash.Substring(0, 12);
                //output += EncodeHash64(hash, 16, encKey);

                //return output;

                string output = "*";
                MD5CryptoServiceProvider md5 = new MD5CryptoServiceProvider();
                if (!passwordHash.StartsWith("$H$")) return output;
                int count_log2 = encKey.IndexOf(passwordHash[3]);
                if (count_log2 < 7 || count_log2 > 30) return output;

                int count = 1 << count_log2;
                byte[] salt = ASCIIEncoding.ASCII.GetBytes(passwordHash.Substring(4, 8));

                if (salt.Length != 8) return output;

                byte[] hash = md5.ComputeHash(sCombine(salt, plainTextPassword));

                do
                {
                    hash = md5.ComputeHash(sCombine(hash, plainTextPassword));
                } while (count-- > 1);

                output = passwordHash.Substring(0, 12);
                output += EncodeHash64(hash, 16, encKey);

                return output;
            }//compute the hash from the password and hash
            private static byte[] sCombine(byte[] b1, byte[] b2)
            {
                byte[] retVal = new byte[b1.Length + b2.Length];
                Array.Copy(b1, 0, retVal, 0, b1.Length);
                Array.Copy(b2, 0, retVal, b1.Length, b2.Length);
                return retVal;
            }//Combine two byte arrays
            private static string EncodeHash64(byte[] input, int count, string itoa64)
            {
                string output = "";
                int i = 0; int value = 0;

                do
                {
                    value = input[i++];
                    output += itoa64[value & 0x3f];

                    if (i < count) value |= input[i] << 8;
                    output += itoa64[(value >> 6) & 0x3f];
                    if (i++ >= count)
                        break;

                    if (i < count) value |= input[i] << 16;
                    output += itoa64[(value >> 12) & 0x3f];
                    if (i++ >= count)
                        break;

                    output += itoa64[(value >> 18) & 0x3f];

                } while (i < count);

                return output;
            }//EncodeHash64

            /// <summary>
            /// The encryption string base.
            /// </summary>
            private string itoa64 = "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

            /// <summary>
            /// Compares the password string given with the hash retrieved from your database.
            /// </summary>
            /// <param name="password">Plaintext password.</param>
            /// <param name="hash">Hash from a SQL database</param>
            /// <returns>True if the password is correct, False otherwise.</returns>
            public bool phpbbCheckHash(string password, string hash)
            {
                if (hash.Length == 34) return (hashCryptPrivate(ASCIIEncoding.ASCII.GetBytes(password), hash, itoa64) == hash);
                return false;
            }

            /// <summary>
            /// This function will return the resulting hash from the password string you specify.
            /// </summary>
            /// <param name="password">String to hash.</param>
            /// <returns>Encrypted hash.</returns>
            /// <remarks>
            /// Although this will return the md5 for an older password, I have not added
            /// support for older passwords, so they will not work with this class unless
            /// I or someone else updates it.
            /// </remarks>
            public string phpbb_hash(string password)
            {
                // Generate a random string from a random number with the length of 6.
                // You could use a static string instead, doesn't matter. E.g.
                // byte[] random = ASCIIEncoding.ASCII.GetBytes("abc123");
                byte[] random = ASCIIEncoding.ASCII.GetBytes(new Random().Next(100000, 999999).ToString());

                string hash = hashCryptPrivate(ASCIIEncoding.ASCII.GetBytes(password), hashGensaltPrivate(random, itoa64), itoa64);

                if (hash.Length == 34) return hash;

                return sMD5(password);
            }

            /// <summary>
            /// The workhorse that encrypts your hash.
            /// </summary>
            /// <param name="password">String to be encrypted. Use: ASCIIEncoding.ASCII.GetBytes();</param>
            /// <param name="genSalt">Generated salt.</param>
            /// <param name="itoa64">The itoa64 string.</param>
            /// <returns>The encrypted hash ready to be compared.</returns>
            /// <remarks>
            /// password:  Saves conversion inside the function, lazy coding really.
            /// genSalt:   Returns from hashGensaltPrivate(random, itoa64);
            /// return:    Compare with phpbbCheckHash(password, hash)
            /// </remarks>
            private string hashCryptPrivate(byte[] password, string genSalt, string itoa64)
            {
                string output = "*";
                MD5CryptoServiceProvider md5 = new MD5CryptoServiceProvider();
                if (!genSalt.StartsWith("$H$")) return output;
                //   $count_log2 = strpos($itoa64, $setting[3]);
                int count_log2 = itoa64.IndexOf(genSalt[3]);
                if (count_log2 < 7 || count_log2 > 30) return output;

                int count = 1 << count_log2;
                byte[] salt = ASCIIEncoding.ASCII.GetBytes(genSalt.Substring(4, 8));

                if (salt.Length != 8) return output;

                byte[] hash = md5.ComputeHash(Combine(salt, password));

                do
                {
                    hash = md5.ComputeHash(Combine(hash, password));
                } while (count-- > 1);

                output = genSalt.Substring(0, 12);
                output += hashEncode64(hash, 16, itoa64);

                return output;
            }

            /// <summary>
            /// Private function to concat byte arrays.
            /// </summary>
            /// <param name="b1">Source array.</param>
            /// <param name="b2">Array to add to the source array.</param>
            /// <returns>Combined byte array.</returns>
            private byte[] Combine(byte[] b1, byte[] b2)
            {
                byte[] retVal = new byte[b1.Length + b2.Length];
                Array.Copy(b1, 0, retVal, 0, b1.Length);
                Array.Copy(b2, 0, retVal, b1.Length, b2.Length);
                return retVal;
            }

            /// <summary>
            /// Encode the hash.
            /// </summary>
            /// <param name="input">The hash to encode.</param>
            /// <param name="count">[This parameter needs documentation].</param>
            /// <param name="itoa64">The itoa64 string.</param>
            /// <returns>Encoded hash.</returns>
            private string hashEncode64(byte[] input, int count, string itoa64)
            {
                string output = "";
                int i = 0; int value = 0;

                do
                {
                    value = input[i++];
                    output += itoa64[value & 0x3f];

                    if (i < count) value |= input[i] << 8;
                    output += itoa64[(value >> 6) & 0x3f];
                    if (i++ >= count)
                        break;

                    if (i < count) value |= input[i] << 16;
                    output += itoa64[(value >> 12) & 0x3f];
                    if (i++ >= count)
                        break;

                    output += itoa64[(value >> 18) & 0x3f];

                } while (i < count);

                return output;
            }

            /// <summary>
            /// Generate salt for hash generation.
            /// </summary>
            /// <param name="input">Any random information.</param>
            /// <param name="itoa64">The itoa64 string.</param>
            /// <returns>Generated salt string</returns>
            private string hashGensaltPrivate(byte[] input, string itoa64)
            {
                int iteration_count_log2 = 6;

                string output = "$H$";
                output += itoa64[Math.Min(iteration_count_log2 + 5, 30)];
                output += hashEncode64(input, 6, itoa64);

                return output;
            }

            /// <summary>
            /// Returns a hexadecimal string representation for the encrypted MD5 parameter.
            /// </summary>
            /// <param name="password">String to be encrypted.</param>
            /// <returns>String</returns>
            private string sMD5(string password)
            { return sMD5(password, false); }
            /// <summary>
            /// Returns a hexadecimal string representation for the encrypted MD5 parameter.
            /// </summary>
            /// <param name="password">String to be encrypted.</param>
            /// <param name="raw">Whether or not to produce a raw string.</param>
            /// <returns>String</returns>
            private string sMD5(string password, bool raw)
            {
                MD5CryptoServiceProvider md5 = new MD5CryptoServiceProvider();
                if (raw) return Encoding.ASCII.GetString(md5.ComputeHash(Encoding.ASCII.GetBytes(password)));
                else return BitConverter.ToString(md5.ComputeHash(Encoding.ASCII.GetBytes(password))).Replace("-", "");
            }
        }

        /// <summary>
        /// Used per MIT license. Credited to Josip Medved <jmedved@jmedved.com> Copyright (c) 2012 
        /// </summary>
        public class Pbkdf2
        {

            /// <summary>
            /// Creates new instance.
            /// </summary>
            /// <param name="algorithm">HMAC algorithm to use.</param>
            /// <param name="password">The password used to derive the key.</param>
            /// <param name="salt">The key salt used to derive the key.</param>
            /// <param name="iterations">The number of iterations for the operation.</param>
            /// <exception cref="System.ArgumentNullException">Algorithm cannot be null - Password cannot be null. -or- Salt cannot be null.</exception>
            public Pbkdf2(HMAC algorithm, Byte[] password, Byte[] salt, Int32 iterations)
            {
                if (algorithm == null) { throw new ArgumentNullException("algorithm", "Algorithm cannot be null."); }
                if (salt == null) { throw new ArgumentNullException("salt", "Salt cannot be null."); }
                if (password == null) { throw new ArgumentNullException("password", "Password cannot be null."); }
                this.Algorithm = algorithm;
                this.Algorithm.Key = password;
                this.Salt = salt;
                this.IterationCount = iterations;
                this.BlockSize = this.Algorithm.HashSize / 8;
                this.BufferBytes = new byte[this.BlockSize];
            }

            /// <summary>
            /// Creates new instance.
            /// </summary>
            /// <param name="algorithm">HMAC algorithm to use.</param>
            /// <param name="password">The password used to derive the key.</param>
            /// <param name="salt">The key salt used to derive the key.</param>
            /// <exception cref="System.ArgumentNullException">Algorithm cannot be null - Password cannot be null. -or- Salt cannot be null.</exception>
            public Pbkdf2(HMAC algorithm, Byte[] password, Byte[] salt)
                : this(algorithm, password, salt, 10000)
            {
            }

            /// <summary>
            /// Creates new instance.
            /// </summary>
            /// <param name="algorithm">HMAC algorithm to use.</param>
            /// <param name="password">The password used to derive the key.</param>
            /// <param name="salt">The key salt used to derive the key.</param>
            /// <param name="iterations">The number of iterations for the operation.</param>
            /// <exception cref="System.ArgumentNullException">Algorithm cannot be null - Password cannot be null. -or- Salt cannot be null.</exception>
            public Pbkdf2(HMAC algorithm, String password, String salt, Int32 iterations) :
                this(algorithm, UTF8Encoding.UTF8.GetBytes(password), UTF8Encoding.UTF8.GetBytes(salt), iterations)
            {
            }

            /// <summary>
            /// Creates new instance.
            /// </summary>
            /// <param name="algorithm">HMAC algorithm to use.</param>
            /// <param name="password">The password used to derive the key.</param>
            /// <param name="salt">The key salt used to derive the key.</param>
            /// <exception cref="System.ArgumentNullException">Algorithm cannot be null - Password cannot be null. -or- Salt cannot be null.</exception>
            public Pbkdf2(HMAC algorithm, String password, String salt) :
                this(algorithm, password, salt, 10000)
            {
            }

            private readonly int BlockSize;
            private uint BlockIndex = 1;
            private byte[] BufferBytes;
            private int BufferStartIndex = 0;
            private int BufferEndIndex = 0;

            /// <summary>
            /// Gets algorithm used for generating key.
            /// </summary>
            public HMAC Algorithm { get; private set; }

            /// <summary>
            /// Gets salt bytes.
            /// </summary>
            [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Justification = "Byte array is proper return value in this case.")]
            public Byte[] Salt { get; private set; }

            /// <summary>
            /// Gets iteration count.
            /// </summary>
            public Int32 IterationCount { get; private set; }


            /// <summary>
            /// Returns a pseudo-random key from a password, salt and iteration count.
            /// </summary>
            /// <param name="count">Number of bytes to return.</param>
            /// <returns>Byte array.</returns>
            public Byte[] GetBytes(int count)
            {
                byte[] result = new byte[count];
                int resultOffset = 0;
                int bufferCount = this.BufferEndIndex - this.BufferStartIndex;

                if (bufferCount > 0)
                { //if there is some data in buffer
                    if (count < bufferCount)
                    { //if there is enough data in buffer
                        Buffer.BlockCopy(this.BufferBytes, this.BufferStartIndex, result, 0, count);
                        this.BufferStartIndex += count;
                        return result;
                    }
                    Buffer.BlockCopy(this.BufferBytes, this.BufferStartIndex, result, 0, bufferCount);
                    this.BufferStartIndex = this.BufferEndIndex = 0;
                    resultOffset += bufferCount;
                }

                while (resultOffset < count)
                {
                    int needCount = count - resultOffset;
                    this.BufferBytes = this.Func();
                    if (needCount > this.BlockSize)
                    { //we one (or more) additional passes
                        Buffer.BlockCopy(this.BufferBytes, 0, result, resultOffset, this.BlockSize);
                        resultOffset += this.BlockSize;
                    }
                    else
                    {
                        Buffer.BlockCopy(this.BufferBytes, 0, result, resultOffset, needCount);
                        this.BufferStartIndex = needCount;
                        this.BufferEndIndex = this.BlockSize;
                        return result;
                    }
                }
                return result;
            }


            private byte[] Func()
            {
                var hash1Input = new byte[this.Salt.Length + 4];
                Buffer.BlockCopy(this.Salt, 0, hash1Input, 0, this.Salt.Length);
                Buffer.BlockCopy(GetBytesFromInt(this.BlockIndex), 0, hash1Input, this.Salt.Length, 4);
                var hash1 = this.Algorithm.ComputeHash(hash1Input);

                byte[] finalHash = hash1;
                for (int i = 2; i <= this.IterationCount; i++)
                {
                    hash1 = this.Algorithm.ComputeHash(hash1, 0, hash1.Length);
                    for (int j = 0; j < this.BlockSize; j++)
                    {
                        finalHash[j] = (byte)(finalHash[j] ^ hash1[j]);
                    }
                }
                if (this.BlockIndex == uint.MaxValue) { throw new InvalidOperationException("Derived key too long."); }
                this.BlockIndex += 1;

                return finalHash;
            }

            private static byte[] GetBytesFromInt(uint i)
            {
                var bytes = BitConverter.GetBytes(i);
                if (BitConverter.IsLittleEndian)
                {
                    return new byte[] { bytes[3], bytes[2], bytes[1], bytes[0] };
                }
                else
                {
                    return bytes;
                }
            }

        }
    }
}
