﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Configuration;
using System.Data.SqlClient;
using Curse.Extensions;
using Curse.Logging;

namespace Curse.Auth
{
    public static class DatabaseUtility
    {

        private static readonly string ConnectionString = null;
        private static string _readOnlyConnectionString = null;
        
        static DatabaseUtility()
        {
            ConnectionString = ConfigurationManager.ConnectionStrings["AuthenticationDatabase"].ConnectionString;

            if (!ConnectionString.EndsWith(";"))
            {
                ConnectionString = ConnectionString + ";";
            }

            
            _readOnlyConnectionString = ConnectionString;
             
        }

        public static SqlConnection GetAuthConnection()
        {
            return GetAuthConnection(false);
        }

        public static SqlConnection GetAuthConnection(bool readOnly)
        {
            try
            {
                var conn = new SqlConnection(ConnectionString);
                conn.Open();
                return conn;
            }
            catch (Exception exc)
            {
                Logger.Error(exc, "Unable to open database connection.");
                throw;
            }
        }
       

        public static object GetOptionalString(string str)
        {
            if (string.IsNullOrEmpty(str))
                return DBNull.Value;

            return str;
        }

        public static object GetOptionalInt(string str)
        {
            if (string.IsNullOrEmpty(str))
                return DBNull.Value;

            return Convert.ToInt32(str);
        }

    }
}
