﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Curse.Auth
{
    public class AccountRecoveryResult : BaseAuthenticationResult
    {
        public AccountRecoveryResult() { }

        public AccountRecoveryResult(EAccountRecoveryStatus status)
        {
            Status = status;
        }

        public AccountRecoveryResult(EAccountRecoveryStatus status, string message)
        {
            Status = status;
            Message = message;
        }

        public AccountRecoveryResult(EAccountRecoveryStatus status, string emailAddress, string username)
        {
            Status = status;
            EmailAddress = emailAddress;
            Username = username;            
        }

        public AccountRecoveryResult(EAccountRecoveryStatus status, string emailAddress, string username, TimeSpan cooldown)
        {
            Status = status;
            EmailAddress = emailAddress;
            Username = username;
            CooldownMinutes = (int)cooldown.TotalMinutes;
        }

        public AccountRecoveryResult(EAccountRecoveryStatus status, string emailAddress, string username, Int32 token, TimeSpan cooldown, DateTime dateCreated)
        {
            Status = status;
            EmailAddress = emailAddress;
            Username = username;
            CooldownMinutes = (int)cooldown.TotalMinutes;
            DateCreated = dateCreated;
            Token = token;
        }

        public EAccountRecoveryStatus Status
        {
            get;
            set;
        }

        public string EmailAddress
        {
            get;
            set;
        }

        public string Username
        {
            get;
            set;
        }

        public int CooldownMinutes
        {
            get;
            set;
        }

        public DateTime DateCreated
        {
            get;
            set;
        }

        public Int32 Token
        {
            get;
            set;
        }

        
    }
}
