﻿using System;
using NetworkService.BillingService;

namespace Curse.Auth
{
    public class UserEntitlement
    {

        public UserEntitlement()
        {
        }

        public UserEntitlement(AccountEntitlement accountEntitlement)
        {
            this.Expires = accountEntitlement.DateExpires;
            this.ID = accountEntitlement.EntitlementID;
            switch (accountEntitlement.EntitlementID)
            {
                case "CP":
                    this.Type = ESubscriptionType.Premium;
                    break;
                case "GH":
                    this.Type = ESubscriptionType.GuildHosting;
                    break;
                case "VH":
                    this.Type = ESubscriptionType.VentriloHosting;
                    break;        
            }
            this.Active = accountEntitlement.Active;
        }

        public string ID
        {
            get;
            set;
        }

        public ESubscriptionType Type
        {
            get;
            set;
        }

        public DateTime Expires
        {
            get;
            set;
        }

        public bool Active { get; set; }

    }
}
