﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using System.Data;

namespace Curse.Auth
{
    [Serializable]
    public class UserLegacy
    {
        public int SiteID
        {
            get;
            set;
        }

        public ELegacyUserStatus Status
        {
            get;
            set;
        }

        public static List<UserLegacy> GetAllByUserID(int uid, SqlConnection conn)
        {

            var userLegacy = new List<UserLegacy>();

            using(var cmd = conn.CreateCommand())
            {
                cmd.CommandText = "spGetAllLegacyUsers";


                cmd.CommandType = CommandType.StoredProcedure;
                cmd.Parameters.Add("@numUserID", SqlDbType.Int);
                cmd.Parameters["@numUserID"].Value = uid;

                using (var reader = cmd.ExecuteReader())
                {
                    while (reader.Read())
                    {
                        var siteID = reader.GetInt32(0);
                        var statusID = reader.GetInt32(1);

                        userLegacy.Add(new UserLegacy()
                        {
                            SiteID = siteID,
                            Status = (ELegacyUserStatus)statusID
                        });
                    }
                }
            }

            

            return userLegacy;
        }
    }
}
