﻿using System.Net.Mail;

using Curse.Mailer;

namespace Curse.Auth
{
    public class UserMailer
    {

        #region Singleton Implementation

        private static readonly UserMailer _instance = new UserMailer();        

        public static UserMailer Instance
        {
            get
            {
                return _instance;
            }
        }

        #endregion

        #region Fields and Constructor

        private readonly MailAddress _senderAddress = new MailAddress("notification-noreply@curse.com", "Curse");
                
        public UserMailer() { }
        
        #endregion

        #region Public Methods

        public void SendAccountActivation(string recipientEmailAddress, string recipientUsername, string activationLink, string activationCode)
        {
            
            MailProvider.Instance.SendTemplatedMessage("AccountActivation", 
                                                        _senderAddress,
                                                        recipientEmailAddress,
                                                        "Curse Account Activation",
                                                        new string[] { recipientUsername, activationLink, activationCode} );

        }

        public void SendUsernameRecovery(string recipientEmailAddress, string recipientUsername)
        {
            MailProvider.Instance.SendTemplatedMessage("UsernameRecovery",
                                                        _senderAddress,
                                                        recipientEmailAddress,
                                                        "Curse ID Recovery",
                                                        new string[] { recipientUsername });

        }


        public void SendAccountRecovery(string recipientEmailAddress, string recipientUsername, string passwordResetLink, string requestDate, string requestTime, string expirationDate, string expirationTime)
        {
            MailProvider.Instance.SendTemplatedMessage("AccountRecovery",
                                                        _senderAddress,
                                                        recipientEmailAddress,
                                                        "Curse Account Recovery",
                                                        new string[] { recipientUsername, passwordResetLink, requestDate, requestTime, expirationDate, expirationTime });

        }

        public void SendLegacyPasswordResetRequest(string recipientEmailAddress, string recipientUsername, string passwordResetLink)
        {
            MailProvider.Instance.SendTemplatedMessage("PasswordResetRequest", 
                                                        _senderAddress,
                                                        recipientEmailAddress,                                                        
                                                        "Curse Password Reset Instructions",
                                                        new string[] { recipientUsername, passwordResetLink });
            
        }

        public void SendLegacyPasswordResetConfirmation(string recipientEmailAddress, string recipientUsername, string password)
        {
            MailProvider.Instance.SendTemplatedMessage("PasswordResetConfirmation",
                                                        _senderAddress,
                                                        recipientEmailAddress,
                                                        "Curse Password Reset Complete",
                                                        new string[] { recipientUsername, password });
            
        }

        #endregion

    }
}
