using System;
using System.Data;
using System.Data.SqlClient;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Xml;

namespace Curse.Auth
{
    /// <summary>
    /// Global user profile. Used for the profile which is shared between
    /// all network sites in the Curse network.
    /// </summary>
    /// 
    [Serializable]
    public class UserSubscripion
    {
        const int iType = 1;
        const int iSubscribed = 2;
        const int iExpiration = 3;
        const int iLevel = 4;
        const int iActive = 5;

        // Properties

        public ESubscriptionType Type {
            get
            { 
                return _type; 
            }
            set
            {
                _type = value;
            }
        }
        
        public byte Level
        {
            get
            {
                return _level;
            }
            set
            {
                _level = value;
            }
        }

        public DateTime SignupDate
        {
            get
            {
                return _signupDate; 
            }
            set
            {
                _signupDate = value;
            }
        }
        
        public DateTime ExpirationDate
        {
            get
            {
                return _expirationDate;
            }
            set
            {
                _expirationDate = value;
            }
        }
        
        public bool Active
        {
            get
            {
                return _expirationDate.AddDays(1) > DateTime.UtcNow;
            }
            set { }
        }
        
        public bool Cancelled
        {
            get
            {
                return _cancelled;
            }
            set
            {
                _cancelled = value;
            }
        }

        ESubscriptionType _type;
        byte _level;
        DateTime _signupDate;
        DateTime _expirationDate;
        bool _cancelled;

        public static List<UserSubscripion> GetUserSubscriptions(int uid, SqlConnection conn)
        {
            SqlCommand cmd = new SqlCommand("spSubscriptionsFromUserID", conn);
            cmd.CommandType = CommandType.StoredProcedure;
            cmd.Parameters.Add("@numUserID", SqlDbType.Int);
            cmd.Parameters["@numUserID"].Value = uid;
            List<UserSubscripion> subscriptions = new List<UserSubscripion>();
            using (SqlDataReader reader = cmd.ExecuteReader())
            {
                while (reader.Read())
                {
                    subscriptions.Add(new UserSubscripion(reader));
                }
            }

            return subscriptions;
        }

        public UserSubscripion() {}
        
        public UserSubscripion(SqlDataReader reader)
        {

            _type = (ESubscriptionType)reader.GetInt16(iType);
            _level = reader.GetByte(iLevel);
            _signupDate = reader.GetDateTime(iSubscribed);
            _expirationDate = reader.GetDateTime(iExpiration);
            _cancelled = !reader.GetBoolean(iActive);
        }
        
        public void serialize(XmlWriter to)
        {
            to.WriteStartElement("subscription");

            to.WriteStartAttribute("type");
            to.WriteValue((int)_type);
            to.WriteEndAttribute();

            to.WriteStartAttribute("level");
            to.WriteValue(_level.ToString());
            to.WriteEndAttribute();

            to.WriteStartAttribute("signupDate");
            to.WriteValue(_signupDate.ToString());
            to.WriteEndAttribute();

            to.WriteStartAttribute("expirationDate");
            to.WriteValue(_expirationDate.ToString());
            to.WriteEndAttribute();

            to.WriteStartAttribute("active");
            to.WriteValue(Active.ToString());
            to.WriteEndAttribute();

            to.WriteStartAttribute("cancelled");
            to.WriteValue(Cancelled.ToString());
            to.WriteEndAttribute();


            to.WriteEndElement();
        }
       
    }
}
