﻿using System;
using System.Linq;
using Curse.Azeroth.DB;
using Curse.Azeroth.Models;
using System.Data.SqlClient;
using System.Collections.Generic;
using Curse.Azeroth.Models.WoW;
using System.Data;
using System.Configuration;

namespace Curse.Azeroth.DbObjects.Wow
{
    public class GameObjectDb : DbObject
    {
        public override void Save(IUpdate update, SqlConnection conn)
        {
            if (update is WowUpdate)
            {
                var wowUpdate = update as WowUpdate;
                var bulkCopy = new SqlBulkCopy(conn);

                var objectLocations = new DataTable();

                DbUtilities.LoadSchema(ref objectLocations, "Location", conn);

                PopulateObjectIds(ref wowUpdate);

                #region Save the Object Locations
                foreach (var gameObject in wowUpdate.GameObjects)
                {
                    foreach (var instanceInfo in gameObject.InstanceInfo)
                    {
                        foreach (var location in instanceInfo.Locations)
                        {
                            foreach (var coord in location.Coordinates)
                            {
                                var locRow = objectLocations.NewRow();
                                locRow["Build"] = wowUpdate.Build;
                                locRow["EntityTypeID"] = int.Parse(ConfigurationManager.AppSettings["ObjectEntityID"]); // Object
                                locRow["EntityID"] = gameObject.ID;
                                locRow["InstanceDifficultyID"] = instanceInfo.InstanceDifficulty;
                                locRow["ZoneID"] = location.LocationID;
                                locRow["MapLevel"] = coord.MapLevel;
                                locRow["X"] = coord.X;
                                locRow["Y"] = coord.Y;
                                locRow["DateCreated"] = DateTime.UtcNow;

                                objectLocations.Rows.Add(locRow);
                            }
                        }
                    }
                }
                #endregion

                bulkCopy.DestinationTableName = "Location";
                bulkCopy.WriteToServer(objectLocations);
            }
        }

        public void PopulateObjectIds(ref WowUpdate update)
        {
            var objectIds = new Dictionary<string, int>();
            using (var conn = new SqlConnection(ConfigurationManager.ConnectionStrings["Azeroth"].ConnectionString))
            {
                var cmd = new SqlCommand("SELECT Id FROM WowObject WHERE Name = @Name", conn);
                cmd.Parameters.Add("Name", SqlDbType.VarChar);

                conn.Open();
                foreach (var gameObject in update.GameObjects.Where(p => p.ID == null))
                {
                    if (!objectIds.ContainsKey(gameObject.Name))
                    {
                        cmd.Parameters["Name"].Value = gameObject.Name;
                        var objectValue = cmd.ExecuteScalar();
                        if (objectValue != null)
                        {
                            objectIds.Add(gameObject.Name, (int)objectValue);
                        }
                        else objectIds.Add(gameObject.Name, 0);
                    }
                    gameObject.ID = objectIds[gameObject.Name];
                }
            }
        }
    }
}