﻿using System;
using Curse.Azeroth.DB;
using Curse.Azeroth.Models;
using System.Data.SqlClient;
using System.Data;
using Curse.Azeroth.Models.WoW;

namespace Curse.Azeroth.DbObjects.Wow
{
    public class ItemDb : DbObject
    {
        public override void Save(IUpdate update, SqlConnection conn)
        {
            if (update is WowUpdate)
            {
                var wowUpdate = update as WowUpdate;
                var bulkCopy = new SqlBulkCopy(conn);

                var itemTable = new DataTable();
                var itemDropTable = new DataTable();
                var itemDropCountTable = new DataTable();

                DbUtilities.LoadSchema(ref itemTable, "ItemDurability", conn);
                DbUtilities.LoadSchema(ref itemDropTable, "[Drop]", conn);
                DbUtilities.LoadSchema(ref itemDropCountTable, "DropCount", conn);

                foreach (var item in wowUpdate.Items)
                {
                    var row = itemTable.NewRow();
                    row["Build"] = wowUpdate.Build;
                    row["ItemID"] = item.Id;
                    row["MaxDurability"] = item.Durability;
                    row["DateCreated"] = DateTime.UtcNow;
                    itemTable.Rows.Add(row);

                    #region Disenchant Drops
                    foreach (var disenchant in item.Disenchant)
                    {
                        var dropRow = itemDropTable.NewRow();
                        dropRow["Build"] = wowUpdate.Build;
                        dropRow["InstanceDifficultyID"] = InstanceDifficulty.NONE;
                        dropRow["DropID"] = disenchant.ItemId;
                        dropRow["DropTypeID"] = DropType.ITEM;
                        dropRow["SourceID"] = item.Id;
                        dropRow["SourceTypeID"] = DropSourceType.ENCHANTING;
                        dropRow["Quantity"] = disenchant.Quantity;
                        dropRow["DateCreated"] = DateTime.UtcNow;

                        itemDropTable.Rows.Add(dropRow);
                    }
                    #endregion

                    #region DisenchantCount
                    if (item.DisenchantCount != default(int))
                    {
                        var countRow = itemDropCountTable.NewRow();
                        countRow["Build"] = wowUpdate.Build;
                        countRow["InstanceDifficultyID"] = InstanceDifficulty.NONE;
                        countRow["SourceID"] = item.Id;
                        countRow["SourceTypeID"] = DropSourceType.ENCHANTING;
                        countRow["TimesLooted"] = item.DisenchantCount;
                        countRow["DateCreated"] = DateTime.UtcNow;

                        // I only want one of these but have to put this here because of the instance level ID
                        if (item.DisenchantCount > 0)
                        {
                            itemDropCountTable.Rows.Add(countRow);
                        }
                    }
                    #endregion
                }

                bulkCopy.DestinationTableName = "ItemDurability";
                bulkCopy.WriteToServer(itemTable);

                bulkCopy.DestinationTableName = "[Drop]";
                bulkCopy.WriteToServer(itemDropTable);

                bulkCopy.DestinationTableName = "[DropCount]";
                bulkCopy.WriteToServer(itemDropCountTable);
            }
        }
    }
}