﻿function split(str, delim, maxNb)
	if not str then
		return nil
	end

    -- Eliminate bad cases...
    if string.find(str, delim) == nil then
        return str
    end
    if maxNb == nil or maxNb < 1 then
        maxNb = 0    -- No limit
    end
    local result = {}
    local pat = "(.-)" .. delim .. "()"
    local nb = 0
    local lastPos
    for part, pos in string.gfind(str, pat) do
        nb = nb + 1
        result[nb] = part
        lastPos = pos
        if nb == maxNb then break end
    end
    -- Handle the last field
    if nb ~= maxNb then
        result[nb + 1] = string.sub(str, lastPos)
    end
    return unpack(result)
end

function splitGetLast(str, delim)
	local result = {split(str, delim)};

	return result[#result];
end

TYPE_MONEY = 0;
TYPE_ITEM = 20001;
TYPE_SPELL = 20002;
TYPE_FACTION = 20027;
TYPE_AREA = 20039;
TYPE_QUEST = 20044;
TYPE_NPC = 20055;
TYPE_OBJECT = 20094;
TYPE_CURRENCY = 20059;
TYPE_ZONE = TYPE_AREA;

DROP_KILLING = 1;
DROP_DISENCHANT = 2;
DROP_ENGINEERING = 3;
DROP_EXTRACT_GAS = 4;
DROP_FISHING = 5;
DROP_HERB_GATHERING = 6;
DROP_MILLING = 7;
DROP_MINING = 8;
DROP_OPENING = 9;
DROP_PICK_POCKET = 10;
DROP_PROSPECTING = 11;
DROP_SEARCHING_FOR_ARTIFACTS = 12;
DROP_SKINNING = 13;

DropTypes = {
	["DROPS"] = DROP_KILLING,	-- has both names
	["KILLING"] = DROP_KILLING,
	["DISENCHANT"] = DROP_DISENCHANT,
	["ENGINEERING"] = DROP_ENGINEERING,
	["EXTRACT_GAS"] = DROP_EXTRACT_GAS,
	["FISHING"] = DROP_FISHING,
	["HERB_GATHERING"] = DROP_HERB_GATHERING,
	["MILLING"] = DROP_MILLING,
	["MINING"] = DROP_MINING,
	["OPENING"] = DROP_OPENING,
	["PICK_POCKET"] = DROP_PICK_POCKET,
	["PROSPECTING"] = DROP_PROSPECTING,
	["SEARCHING_FOR_ARTIFACTS"] = DROP_SEARCHING_FOR_ARTIFACTS,
	["SKINNING"] = DROP_SKINNING,
};

function GetDropType(str)
	if(str == "drops") then str = "KILLING"; end
	return DropTypes[string.upper(str)];
end