﻿using Curse.Azeroth.LuaImporter;
using System.Configuration;

namespace Curse.AzerothService.Managers
{
    public class ParserManager
    {
        ParserEngine _parser;
        string _luaFileLocation = string.Empty;
        string _genericDbConnection = string.Empty;

        static ParserManager _instance = new ParserManager();
        public static ParserManager Instance { get { return _instance; } }

        public ParserManager()
        {
            _genericDbConnection = ConfigurationManager.ConnectionStrings["GenericConnection"].ConnectionString;
            _luaFileLocation = ConfigurationManager.AppSettings["LuaFileLocation"];
            _parser = new ParserEngine(_luaFileLocation, _genericDbConnection);
        }
        public void Initialize() { }

        public ParserEngine GetParser()
        {
            return _parser;
        }
    }
} 