﻿using System;
using Curse.AzerothService.Extensions;
using Curse.Extensions;

namespace Curse.AzerothService.Models
{
    public class GameUpdate : Update
    {
        public GameUpdate(long minProfilerVersion, int[] supportedClientVersions, string[] supportedLocals, int userId, bool isTrustedUser) : base(minProfilerVersion, supportedClientVersions, supportedLocals, userId, isTrustedUser) { }

        #region IUpdate Members
        public override void Clear() 
        {
            UpdateData = string.Empty;
        }
        #endregion

        #region IPackable Members
        public override bool Read(IReadable buffer)
        {
            try
            {
                string data = ((Package)buffer).DumpToString();
                UpdateData = data;
                return true;
            }
            catch (Exception exc)
            {
                Logger.Log("Failed to read Update. Details: {0}", ELogLevel.Error, exc.GetExceptionDetails());
                UpdateStatus = StatusCode.InvalidStream;
                return false;
            }
        }
        public override bool Write(IWriteable buffer)
        {
            return true;
        }
        #endregion
    }
}
