﻿using System;
using System.Collections.Generic;
using System.ServiceModel;
using Curse.AzerothService.Caching;
using Curse.AzerothService.Extensions;
using Curse.AzerothService.Models;
using Curse.Extensions;
using System.IO;
using Curse.ServiceModels.Configuration;

namespace Curse.AzerothService
{
    [ServiceBehavior(Name = "WowDbService", Namespace = "http://data-service.wowdb.com/", AddressFilterMode = AddressFilterMode.Any, ConcurrencyMode = ConcurrencyMode.Multiple)]
    public class WowDbService : IWowDbService
    {
        object _startLock = new object();

        public WowDbService()
        {
            if (string.IsNullOrEmpty(Logger.LogFileFullPath))
            {
                lock (_startLock)
                {
                    try
                    {
                        var config = ServiceConfiguration.Instance;

                        #region Init Logger
                        string logLevel = config.Logging.LogLevel;
                        switch (logLevel.ToLower())
                        {
                            case "debug":
                                Logger.SetLogLevel = ELogLevel.Debug;
                                break;
                            case "access":
                                Logger.SetLogLevel = ELogLevel.Access;
                                break;
                            case "error":
                                Logger.SetLogLevel = ELogLevel.Error;
                                break;
                            case "info":
                                Logger.SetLogLevel = ELogLevel.Info;
                                break;
                            case "warning":
                                Logger.SetLogLevel = ELogLevel.Warning;
                                break;
                        }
                        Logger.SetAutoGrowthMegabytes = 50;
                        Logger.SetLogPath = config.Logging.LogPath;
                        #endregion
                    }
                    catch (Exception exc)
                    {
                        Logger.Log("Failed to start service. Details: {0}", ELogLevel.Error, exc.GetExceptionDetails());
                    }
                }
            }
        }

        public CanUploadResponse CanUploadFile(int userId)
        {
            var response = new CanUploadResponse { CanUpload = !DbCache.Instance.IsRateLimitExceeded(userId) };
            response.FileTypes = new List<string>(DbCache.Instance.AcceptedFileTypes);
            return response;
        }
        public void UploadDbFile(UploadDbFileMessage input)
        {
            try
            {
                using (var sourceStream = input.FileByteStream)
                {
                    var memStream = new MemoryStream();
                    memStream.ReadFromWebStream(sourceStream);
                    var unzippedStream = memStream.Unzip();

                    Logger.Log("Upload DbFile - Received {0} bytes for userID {1}", ELogLevel.Info, unzippedStream.Length, input.UserID);
                    DbCache.Instance.QueueUpload(input.UserID, input.FileName, unzippedStream);
                }
            }
            catch (Exception exc)
            {
                Logger.Log("UploadDbFile Exception: {0}", ELogLevel.Error, exc.GetExceptionDetails());
            }
        }
    }
}
