﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace VindiciaTests
{
    public enum BillingResultStatus
    {
        Successful = 1,
        Unsuccessful,
        UnknownException,
    }

    public class BillingResult<T> where T : class
    {
        public BillingResultStatus Status
        {
            get;
            set;
        }

        public string ProviderMessage
        {
            get;
            set;
        }

        public string Message
        {
            get;
            set;
        }

        public T Value
        {
            get;
            set;
        }
        public BillingResult() { }

        public BillingResult(BillingResultStatus status)
        {
            Status = status;            
        }

        public BillingResult(BillingResultStatus status, string message)
        {
            Status = status;
            Message = message;
        }

        public BillingResult(BillingResultStatus status, string message, string providerMessage)
        {
            Status = status;
            Message = message;
            ProviderMessage = providerMessage;
        }

        public BillingResult(BillingResultStatus status, T value)
        {
            Status = status;            
            Value = value;
        }

        public BillingResult(BillingResultStatus status, string message, T value)
        {
            Status = status;
            Message = message;
            Value = value;
        }
        
    }
}
