﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VindiciaTests.BillingService;
using System.Diagnostics;

namespace VindiciaTests
{
    public static class BillingServiceTests
    {

        public static void TestAccountCreation(string accountID, bool usePayPal)
        {
            // 1. Create a new account
            AccountInformation accountInfo = new AccountInformation()
            {
                ID = accountID,
                EmailAddress = accountID + "@curse.com",
                Name = "Michael Comperda",
                Address = new AccountAddress()
                {
                    Address1 = "103 McDermotts Way",
                    City = "Madison",
                    Country = "US",
                    Name = "Michael Comperda",
                    Phone = "256-722-8033",
                    PostalCode = "35758",
                    District = "AL"

                },
            };

            // 2. Create a payment method
            AccountPaymentMethod paymentMethod = new AccountPaymentMethod();

            if (usePayPal)
            {
                SetPayPalPaymentMethod(paymentMethod);
            }
            else
            {
                SetCreditCardPaymentMethod(paymentMethod);
            }

            using (BillingServiceClient client = new BillingServiceClient("WsHttpClientServiceEndpoint"))
            {
                ServiceResponse resp1 = client.CreateOrUpdateAccount(accountInfo);
                ServiceResponseOfAccountPaymentMethod resp2 = client.CreateOrUpdatePaymentMethod(accountID, paymentMethod);
            }

        }

        private static void SetCreditCardPaymentMethod(AccountPaymentMethod creditCard)
         {
            
            creditCard.AccountHolderName = "Michael Comperda";
            creditCard.AccountNumber = "4485983356242217";
            creditCard.ExpirationYear = 2011;
            creditCard.ExpirationMonth = 5;
            creditCard.Type = AccountPaymentType.CreditCard;
            creditCard.Description = "My Visa Card";
            creditCard.Address = new AccountAddress()
            {
                Address1 = "100 Foxfire Drive",
                City = "Huntsville",
                Country = "US",
                Name = "Michael Comperda",
                Phone = "256-830-9213",
                PostalCode = "35803",
                District = "AL"
            };
            creditCard.CvnCode = "123";            
        }

        private static void SetPayPalPaymentMethod(AccountPaymentMethod payPal)
        {

            payPal.AccountHolderName = "Michael Comperda";
            payPal.Type = AccountPaymentType.PayPal;
            payPal.EmailAddress = "mcompe_1221110275_per@curse.com";
            payPal.PayPalCancelUrl = "http://www.wowsteadalpha.com/guild/paypal-checkout-failed";
            payPal.PayPalReturnUrl = "http://www.wowsteadalpha.com/guild/paypal-checkout-complete";
            payPal.Description = "My PayPal Account";

            payPal.Address = new AccountAddress()
            {
                Address1 = "100 Foxfire Drive",
                City = "Huntsville",
                Country = "US",
                Name = "Michael Comperda",
                Phone = "256-830-9213",
                PostalCode = "35803",
                District = "AL"
            };

        }

        public static void TestPurchasing(string accountID, bool usePayPal)
        {
            TestAccountCreation(accountID, usePayPal);            

            ShoppingCart cart = new ShoppingCart();

            cart.Currency = CurrencyType.USD;

            // Add a Curse Premium Monthly
            cart.Items = new List<ShoppingCartItem>();            
            cart.Items.Add(new ShoppingCartItem() { ProductID = "CP-G", BillingPlanID = "CP-1M-G", Quantity = 2 });
            //cart.Items.Add(new ShoppingCartItem() { ProductID = "CP", BillingPlanID = "CP-1M-S", Quantity = 1, SubscriptionStartDate = new DateTime(2010, 10, 1) });
            //cart.Items.Add(new ShoppingCartItem() { ProductID = "CP", BillingPlanID = "CP-1M-S", Quantity = 1 });
            
            using (BillingServiceClient client = new BillingServiceClient("WsHttpClientServiceEndpoint"))
            {


                // 1. Get the account info
                ServiceResponseOfAccountInformation resp1 = client.GetAccountInformation(accountID);

                if (resp1.Status != ServiceResponseStatus.Successful)
                {
                    throw new Exception("Something bad happened!");
                }

                // 2. Get the first payment methof
                AccountInformation accountInfo = resp1.Value;
                AccountPaymentMethod paymentMethod = accountInfo.PaymentMethods.FirstOrDefault();

                if (paymentMethod.Type == AccountPaymentType.PayPal)
                {
                    SetPayPalPaymentMethod(paymentMethod);
                }


                paymentMethod.CvnCode = "123";

                ServiceResponseOfCheckout checkoutResponse = client.PurchaseProducts(1, 1, 2, 1, accountID, paymentMethod.ID, paymentMethod, cart);

                if (checkoutResponse.Status == ServiceResponseStatus.PurchaseProducts_PaymentPending)
                {
                    Process.Start(checkoutResponse.Value.PayPalRedirectUrl);
                }
                else if (checkoutResponse.Status == ServiceResponseStatus.Successful)
                {
                    Checkout checkout = checkoutResponse.Value;

                    foreach (ProductPurchase purchase in checkout.PurchasedProducts)
                    {
                        Console.WriteLine("You purchased: " + purchase.ProductDescription);

                        foreach (ProductFulfillment fulfillment in purchase.Fulfillments)
                        {
                            Console.WriteLine("You have received a " + fulfillment.Type + ": " + fulfillment.Data);
                        }

                    }

                    foreach (Subscription sub in checkout.PurchasedSubscriptions)
                    {
                        Console.WriteLine("You subscribed to: " + sub.PlanDescription);
                        if (sub.HasNextBilling)
                        {
                            Console.WriteLine("You will be automatically billed: " + sub.NextBillAmount + " on " + sub.NextBillingDate);
                        }
                    }

                    Console.ReadKey();
                }
                else
                {
                    throw new Exception("Something bad happened: " + checkoutResponse.Message);
                }

                
                
            }
        }

        public static void TestValidateCoupon(string code, string accountID)
        {
            using (BillingServiceClient client = new BillingServiceClient("WsHttpClientServiceEndpoint")) {
                //Coupon couponTest = client.CreateCoupon("CP-1M-G").Value;
                                
                ServiceResponse response = client.ValidateCoupon(code, accountID);
                if (response.Status == ServiceResponseStatus.Successful) {
                    Console.WriteLine(string.Format("{0} is valid", code));
                    response = client.ClaimCoupon(0, 0, 0, 0, code, accountID);

                    if (response.Status == ServiceResponseStatus.Successful)
                        Console.WriteLine("Code successfully claimed");
                    else Console.WriteLine(string.Format("Claim Failed - {0}, {1}", response.Status, response.Message));
                }//claim the code now for the account
                else Console.WriteLine(string.Format("Validation Failed - {0}, {1}", response.Status, response.Message));
            }//using client

            Console.ReadLine();
        }//Validate Coupon
    }//BillingServiceTests
}//namespace
