﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net;
using System.Globalization;
using System.Diagnostics;

using Vindicia;
using Curse.Vindicia;
using Curse.Vindicia.Extensions;
using VindiciaTests.BillingService;

namespace VindiciaTests
{
    class Program
    {
        // Testing Constants - Require Updates
        private const ETestMode TestMode = ETestMode.Service_ValidateCoupon; //ETestMode.Service_TestCreditTokens;
        private const string TestUserID = "T-7";

        private const string VindiciaUsername = "curse_soap";
        private const string VindiciaPassword = "35PL2dm4T5iwKDIEXRLdUF07wCRWcyVD";
        private const string VindiciaEndpointUrl = "soap.prodtest.sj.vindicia.com";

       
        // Testing Constants - Optional UPdates
        private const string TestUserName = "Michael Comperda";
        private const string TestProductID = "CP";
        private const string TestTokenID = "CP";
        private const string TestRegularPlanID = "CP-1M";
        private const string TestTokenPlanID = "CP-T";
        private const string TestChangePlanID = "CP-1M";
        private const string TestGiftPlanID = "CP-1M-G";

        // Testing Statics
        private static string _testSubscription = null;
        private static string _testAccountEmail = TestUserID + "@curse.com";        

        
        static void Main(string[] args)
        {

            ServicePointManager.ServerCertificateValidationCallback = delegate { return true; };

            Vindicia.Environment.SetEndpoint(VindiciaEndpointUrl);
            Vindicia.Environment.SetAuth(VindiciaUsername, VindiciaPassword);

            switch(TestMode)
            {
                case ETestMode.Service_TestAccountCreation:
                    BillingServiceTests.TestAccountCreation(TestUserID, false);
                    break;

                case ETestMode.TestCreateAccount:
                    TestCreateAccount();
                    break;

                case ETestMode.Service_TestPurchasing:
                    TestPurchasing();
                    break;

                case ETestMode.TestCreateRegularSubscription:
                    TestCreateRegularSubscription();
                    break;

                case ETestMode.TestCreateGiftedSubscription:
                    TestCreateGiftedSubscription();
                    break;

                case ETestMode.TestCreateTokenSubscription:
                    TestCreateTokenSubscription();
                    break;

                case ETestMode.TestChangeSubscriptionPlan:
                    TestChangeSubscriptionPlan();
                    break;

                case ETestMode.TestChangeSubscriptionPlanFromTokenToCredit:
                    TestChangeSubscriptionPlanFromTokenToCredit();
                    break;

                case ETestMode.Service_TestVentrilo:
                    TestVentrilo();
                    break;

                case ETestMode.Service_TestCreditTokens:
                    TestCreditTokens();
                    break;

                case ETestMode.Service_ValidateCoupon:
                    //Test with an invalid account
                    BillingServiceTests.TestValidateCoupon("3B9F-2FB9-6929-4AC9", TestUserID);
                    
                    //Test with a valid account
                    BillingServiceTests.TestValidateCoupon("3B9F-2FB9-6929-4AC9", "U-4735982-JasonTest008");

                    //Test an expired coupon
                    BillingServiceTests.TestValidateCoupon("8329-C246-EABF-45FA", "U-4735982-JasonTest008");
                    break;
            }

            return;

            AutoBill[] autoBills = Retrieval.GetAllAutoBillsByAccountID(TestUserID);            
            autoBills = Retrieval.GetAllAutoBillsByAccountID(TestUserID);
            AutoBill latestSub = autoBills.OrderByDescending(p => p.startTimestamp).FirstOrDefault();
            _testSubscription = latestSub.VID;

            // Temporarily wait 1 minute seconds, before cancellation:
            //System.Threading.Thread.Sleep(1000 * 60 * 10);

            // Cancel the Subscription
            //CancelSubscription(_testSubscription);

            // Change the plan            
            //ChangeSubscriptionPlan(_testSubscription, TestUpgradePlanID);            

        }


        #region Testing Methods

        private static void TestVentrilo()
        {
            IPAddress ipAddress = IPAddress.Parse("192.168.1.1");
            int port = 80;
            string accountID = "U-1";
            Int64 clientID = 1;
            Int64 serviceID = 1;

            using (BillingServiceClient client = new BillingServiceClient("WsHttpClientServiceEndpoint"))
            {
                ServiceResponseOfAccountVoiceClient resp = client.AddAccountVoiceService(accountID, clientID, serviceID, ipAddress, port);                
            }

            ipAddress = IPAddress.Parse("192.168.1.2");
            port = 81;
            using (BillingServiceClient client = new BillingServiceClient("WsHttpClientServiceEndpoint"))
            {
                //ServiceResponse resp = client.UpdateAccountVoiceService(accountID, serviceID, ipAddress, port, AccountVoiceServiceStatus.Active);
            }


        }

        private static void TestPurchasing()
        {            
            BillingServiceTests.TestPurchasing(TestUserID, true);
        }

        private static void TestCreditTokens()
        {
            using (BillingServiceClient client = new BillingServiceClient("WsHttpClientServiceEndpoint"))
            {
                List<AccountTokenAmount> amounts = new List<AccountTokenAmount>();
                amounts.Add(new AccountTokenAmount() { Amount = 10, Type = new AccountTokenType() { ID = "VH" } });
                //client.CreditTokens("Adamar", "U-1", amounts);
                ServiceResponse response = client.CreditTokens("Adamar", "U-1", amounts);
            }
        }

        private static void TestChangeSubscriptionPlan()
        {
            // Create an Account
            CreatePersonalAccount(TestUserID, _testAccountEmail);

            // Setup the payment method
            AddPaymentMethod(TestUserID, TestUserID + "-1", TestUserName);

            // Create a Regular Subscription
            BillingResult<AutoBill> result = CreateSubscription(TestUserID, TestProductID, TestRegularPlanID, null);

            // Oh no, a problem occured!
            if (result.Status != BillingResultStatus.Successful)
            {
                throw new Exception("Subscription creation failed! Provider message is: " + result.ProviderMessage);                
            }

            // Immediately Change It
            ChangeSubscriptionPlan(result.Value.VID, TestChangePlanID);

        }

        private static void TestChangeSubscriptionPlanFromTokenToCredit()
        {
            // Create an Account
            CreatePersonalAccount(TestUserID, _testAccountEmail);

            // Add Tokens to the Account
            AddTokensToAccount(TestUserID, TestTokenID, 10);

            // Create a Token Subscription
            BillingResult<AutoBill> result = CreateTokenSubscription(TestUserID, TestProductID, TestRegularPlanID, null, TestTokenID);

            // Oh no, a problem occured!
            if (result.Status != BillingResultStatus.Successful)
            {
                throw new Exception("Subscription creation failed! Provider message is: " + result.ProviderMessage);
            }

            // Setup the payment method
            AddPaymentMethod(TestUserID, TestUserID + "-1", TestUserName);

            // Immediately Change It
            ChangeSubscriptionPlan(result.Value.VID, TestChangePlanID);

        }

        private static void TestCreateTokenSubscription()
        {
            // Create an Account
            CreatePersonalAccount(TestUserID, _testAccountEmail);

            // Add Tokens to the Account
            AddTokensToAccount(TestUserID, "CP", 10);

            // Create a Token-Based Subscription
            CreateTokenSubscription(TestUserID, TestProductID, TestTokenPlanID, null, "CP");
        }

        private static void TestCreateGiftedSubscription()
        {
            // Create an Account
            CreatePersonalAccount(TestUserID, _testAccountEmail);
            
            // Create a Gifted Subscription
            CreateSubscription(TestUserID, TestProductID, TestGiftPlanID, null);
        }

        private static void TestCreateRegularSubscription()
        {
            // Create an Account
            CreatePersonalAccount(TestUserID, _testAccountEmail);

            // Setup the payment method
            AddPaymentMethod(TestUserID, TestUserID + "-1", TestUserName);

            // Create a Regular Subscription
            CreateSubscription(TestUserID, TestProductID, TestRegularPlanID, null);

            Entitlement[] entitlements = Retrieval.GetAllEntitlementsByAccountID(TestUserID, false);
        }

        private static void TestCreateAccount()
        {            
            // Create an Account
            CreatePersonalAccount(TestUserID, _testAccountEmail);

            //Entitlement[] entitlements = Retrieval.GetAllEntitlementsByAccountID(TestUserID, false);
        }


        #endregion

        private static void FetchAllBillingPlans()
        {
            // Billing Plans
            BillingPlan[] billingPlans;
            BillingPlan billingPlan = new BillingPlan();
            billingPlan.fetchAll(0, 100, out billingPlans);
        }

        private static void FetchAllProducts()
        {
            // Products
            Product[] products;
            Product p = new Product();
            p.fetchAll(0, 100, out products);
        }

        private static void CancelAllSubscriptions(string accountID)
        {
            AutoBill[] autoBills = Retrieval.GetAllAutoBillsByAccountID(accountID);

            foreach (AutoBill ab in autoBills)
            {                
                ab.cancel(true, false);
            }
        }

        private static BillingResult<AutoBill> CreateTokenSubscription(string accountID, string productID, string billingPlanID, DateTime? startDate, string tokenID)
        {
            AutoBill ab = new AutoBill();
            ab.account = new Account() { merchantAccountId = accountID };
            ab.product = new Product() { merchantProductId = productID };
            ab.billingPlan = new BillingPlan { merchantBillingPlanId = billingPlanID };
            
            PaymentMethod method = new PaymentMethod() { type = PaymentMethodType.Token, token = new Token() { merchantTokenId = tokenID } };
            ab.paymentMethod = method;

            if (startDate.HasValue)
            {
                ab.startTimestamp = startDate.Value;
            }

            bool created = false;
            bool validatePayment = false;
            TransactionStatus transactionStatus;
            DateTime firstBillDate;
            decimal firstBillAmount;
            string firstBillCurrency;

            Return ret = ab.update(DuplicateBehavior.Fail, validatePayment, 100, out created, out transactionStatus, out firstBillDate, out firstBillAmount, out firstBillCurrency);

            if (ret.returnCode == ReturnCode.Item200)
            {
                return new BillingResult<AutoBill>(BillingResultStatus.Successful, ab);
            }
            else
            {
                return new BillingResult<AutoBill>(BillingResultStatus.Unsuccessful, "Subscription creation failed.", ret.returnString);
            }
        }

        private static BillingResult<AutoBill> CreateSubscription(string accountID, string productID, string billingPlanID, DateTime? startDate)
        {
            AutoBill ab = new AutoBill();
            ab.account = new Account() { merchantAccountId = accountID };
            ab.product = new Product() { merchantProductId = productID };
            ab.billingPlan = new BillingPlan { merchantBillingPlanId = billingPlanID };
            
            if (startDate.HasValue)
            {
                ab.startTimestamp = startDate.Value;
            }

            bool created = false;
            bool validatePayment = true;
            TransactionStatus transactionStatus;
            DateTime firstBillDate;
            decimal firstBillAmount;
            string firstBillCurrency;

            Return ret = ab.update(DuplicateBehavior.Fail, validatePayment, 50, out created, out transactionStatus, out firstBillDate, out firstBillAmount, out firstBillCurrency);

            if (ret.returnCode == ReturnCode.Item200)
            {
                return new BillingResult<AutoBill>(BillingResultStatus.Successful, ab);
            }
            else
            {
                return new BillingResult<AutoBill>(BillingResultStatus.Unsuccessful, "Subscription creation failed.", ret.returnString);
            }
        }

        private static void CancelSubscription(string vindiciaID)
        {
            // 1. Retrieve the existing subscription
            AutoBill ab = Retrieval.GetAutoBillByVID(vindiciaID);

            // 2. Cancel the subscription, but do not remove any entitelements
            ab.cancel(false, false);
        }

        private static void ChangeSubscriptionPlan(string vindiciaID, string newBillingPlanID)
        {
            
            // 1. Retrieve their existing subscription
            AutoBill ab = Retrieval.GetAutoBillByVID(vindiciaID);

            // 2. Retrieve its future billings
            Transaction[] futureRebills = ab.GetFutureRebills(2);
            
            // 3. Find the first future transaction, defaulting to now
            DateTime nextBillDate = DateTime.UtcNow;
            foreach (Transaction futureBilling in futureRebills)
            {
                if (futureBilling.timestamp.NormalizeToUtc() > DateTime.UtcNow)
                {
                    nextBillDate = futureBilling.timestamp.NormalizeToUtc();
                    break;
                }
            }
            
            // 4. Cancel the existing subscription, but do not remove any entitelements
            ab.cancel(false, false);

            // 5. Create a new subscription, future dating it.
            CreateSubscription(ab.account.merchantAccountId, ab.product.merchantProductId, newBillingPlanID, nextBillDate);                       
            
        }

        private static void AddTokensToAccount(string accountID, string tokenID, int quantity)
        {

            Account account = Retrieval.GetAccountByID(accountID);
            Token t = new Token() { merchantTokenId = tokenID };
            TokenAmount tokenAmount = new TokenAmount() { token = t, amount = quantity };                         
            TokenAmount[] tokenAmounts = new TokenAmount[] { tokenAmount };
            Return ret = account.incrementTokens(ref tokenAmounts);
        }

        private static void AddPaymentMethod(string accountID, string paymentMethodID, string accountHolderName)
        {
            Address billingAddress = new Address();
            billingAddress.addr1 = "103 McDermotts Way";
            billingAddress.city = "Madison";
            billingAddress.name = accountHolderName;
            billingAddress.phone = "256-830-9213";
            billingAddress.country = "United States";
            billingAddress.postalCode = "35806";

            CreditCard card = new CreditCard();
            card.account = "4556474670906442";
            card.expirationDate = "201101";

            PaymentMethod method = new PaymentMethod();
            method.accountHolderName = accountHolderName;
            method.billingAddress = billingAddress;
            method.creditCard = card;
            method.type = PaymentMethodType.CreditCard;
            method.active = true;
            method.customerDescription = "My Credit Card";
            method.sortOrder = 0;
            method.merchantPaymentMethodId = paymentMethodID;

            Account account = new Account() { merchantAccountId = accountID };
            bool validated = false;

            Return ret = account.updatePaymentMethod(method, false, PaymentUpdateBehavior.Update, 0, out validated);
        }

        private static void CreatePersonalAccount(string accountID, string emailAddress)
        {
            Address address = new Address();
            address.addr1 = "103 McDermotts Way";
            address.city = "Madison";
            address.name = "Michael Comperda";
            address.phone = "256-830-9213";            
            address.country = "United States";
            address.postalCode = "35806";

            Account account = new Account();
            account.name = "Michael Comperda";
            account.emailAddress = emailAddress;
            account.emailTypePreference = EmailPreference.html;
            account.shippingAddress = address;
            account.merchantAccountId = accountID;
            account.preferredLanguage = CultureInfo.CurrentCulture.Name;           

            bool created = false;
            Return ret = account.update(out created);
        }
                
        private static void CreateGuildAccount()
        {

            Address address = new Address();
            address.addr1 = "100 Main Street";
            address.city = "Huntsville";
            address.country = "United States";
            address.postalCode = "35806";

            Account account = new Account();
            account.name = "Legions Guild";            
            account.emailAddress = "guild00001@curse.com";
            account.emailTypePreference = EmailPreference.html;            
            account.shippingAddress = address;
            account.merchantAccountId = "G-00001";
            account.preferredLanguage = CultureInfo.CurrentCulture.Name;
            
            TokenAmount tokenAmount = new TokenAmount();
            tokenAmount.amount = 1;
            Token token = new Token();
            token.merchantTokenId = "GS-1";
            

            bool created = false;
            account.update(out created);

        }

        
    }//class
}//namespace
