﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.ServiceModel.Activation;
using System.Threading;
using System.ServiceModel.Channels;

using Curse.AddOns;
using Curse.Extensions;
using System.Configuration;
using System.Web;
using Curse.ClientService.Models;
using Curse.ClientService.Extensions;
using System.IO;
using System.ServiceModel.Web;
using System.Text;
using System.Net.Security;
using System.Net;
using Curse.Logging;
//using Curse.ClientService.com.curse.auth;
using System.ServiceModel.Description;
using Curse.ClientService.AdminModels;
using Curse.ClientService.GeoCoding;
using System.Data.SqlClient;
using System.Data;

namespace Curse.ClientService
{
    [ServiceBehavior(Name = "CClientService",
        Namespace = "http://clientservice.curse.com/",
        AddressFilterMode = AddressFilterMode.Any,
        ConcurrencyMode = ConcurrencyMode.Multiple,
        InstanceContextMode = InstanceContextMode.PerSession)]
    public class CClientService : IClientService
    {

        private static object _startLock = new object();


        static CClientService()
        {

            lock (_startLock)
            {

                string logLevel = ConfigurationManager.AppSettings["LogLevel"];
                switch (logLevel.ToLower())
                {
                    case "debug":
                        Logger.SetLogLevel = ELogLevel.Debug;
                        break;
                    case "access":
                        Logger.SetLogLevel = ELogLevel.Access;
                        break;
                    case "error":
                        Logger.SetLogLevel = ELogLevel.Error;
                        break;
                    case "info":
                        Logger.SetLogLevel = ELogLevel.Info;
                        break;
                    case "warning":
                        Logger.SetLogLevel = ELogLevel.Warning;
                        break;
                }
                Logger.SetLogPath = ConfigurationManager.AppSettings["LogPath"];

                try
                {
                    //Initialize the directorys
                    var _feedDirectory = ConfigurationManager.AppSettings["FeedPath"];
                    var _logDirectory = ConfigurationManager.AppSettings["LogPath"];
                    var _userBackupDirectory = ConfigurationManager.AppSettings["UserBackupsPath"];
                    var _themePackDllSourceDirectory = ConfigurationManager.AppSettings["ThemePackDllSourcePath"];

                    if (!Directory.Exists(_logDirectory))
                    {
                        Directory.CreateDirectory(_logDirectory);
                        Logger.Log("Creating Log Directory...", ELogLevel.Info);
                    }

                    Logger.Log("Checking feed directory at: " + _feedDirectory, ELogLevel.Info);
                    if (!Directory.Exists(_feedDirectory))
                    {
                        Directory.CreateDirectory(_feedDirectory);
                        Logger.Log("Creating Feed Directory...", ELogLevel.Info);
                    }

                    Logger.Log("Checking user backup directory at: " + _userBackupDirectory, ELogLevel.Info);
                    if (!Directory.Exists(_userBackupDirectory))
                    {
                        Directory.CreateDirectory(_userBackupDirectory);
                        Logger.Log("Creating User Backup Directory...", ELogLevel.Info);
                    }

                    Logger.Log("Checking theme directory at: " + _themePackDllSourceDirectory, ELogLevel.Info);
                    if (!Directory.Exists(_themePackDllSourceDirectory))
                    {
                        Directory.CreateDirectory(_themePackDllSourceDirectory);
                        Logger.Log("Creating Theme Directory...", ELogLevel.Info);
                    }
                }
                catch (Exception ex)
                {

                    Logger.Log("File IO could not be established. Details: {0}", ELogLevel.Error, ex.GetExceptionDetails());
                    throw;
                }

                try
                {

                    Logger.Log("Initializing Campaigns...", ELogLevel.Info);
                    CCampaignCache.Instance.Initialize();

                    Logger.Log("Initializing Avatars...", ELogLevel.Info);
                    CAvatarCache.Instance.Initialize();

                    Logger.Log("Initializing Category Sections...", ELogLevel.Info);
                    CCategorySectionCache.Instance.Initialize();

                    Logger.Log("Initializing Games...", ELogLevel.Info);
                    CGameCache.Instance.Initialize();

                    Logger.Log("Initializing Categories...", ELogLevel.Info);
                    CCategoryCache.Instance.Initialize();

                    Logger.Log("Initializing Sync...", ELogLevel.Info);
                    CSyncCache.Instance.Initialize();

                    Logger.Log("Initializing Hardware Reporting...", ELogLevel.Info);
                    CHardwareReportCache.Instance.Initialize();

                    Logger.Log("Initializing Usage Reporting...", ELogLevel.Info);
                    CUsageReportingCache.Instance.Initialize();

                    Logger.Log("Initializing Notifications...", ELogLevel.Info);
                    CNotificationCache.Instance.Initialize();

                    Logger.Log("Initializing Addon Cache...", ELogLevel.Info);
                    CAddOnCache.Instance.Initialize();

                    Logger.Log("Initialize IP Database Updater...", ELogLevel.Info);
                    IPDatabaseUpdater.Initialize();

                }
                catch (Exception ex)
                {
                    Logger.Log("Could not start Client Service! Details: {0}", ELogLevel.Error, ex.GetExceptionDetails());
                    throw;
                }
            }

            Logger.Log("Services Started", ELogLevel.Info);
        }


        public CAddOn GetAddOn(int id)
        {
            try
            {
                return CAddOnCache.Instance.GetCachedAddOn(id);
            }
            catch
            {

                return null;
            }

        }

        private static readonly KeyValuePair<ServiceStatisticInterval, TimeSpan>[] _sessionStatisticTimespans = {
                new KeyValuePair<ServiceStatisticInterval, TimeSpan>(ServiceStatisticInterval.Last5Seconds, TimeSpan.FromSeconds(5)), 
                new KeyValuePair<ServiceStatisticInterval, TimeSpan>(ServiceStatisticInterval.Last30Seconds, TimeSpan.FromSeconds(30)), 
                new KeyValuePair<ServiceStatisticInterval, TimeSpan>(ServiceStatisticInterval.LastMinute, TimeSpan.FromMinutes(1)),
                new KeyValuePair<ServiceStatisticInterval, TimeSpan>(ServiceStatisticInterval.Last5Minutes, TimeSpan.FromMinutes(5)),
                new KeyValuePair<ServiceStatisticInterval, TimeSpan>(ServiceStatisticInterval.Last10Minutes, TimeSpan.FromMinutes(10)),
                new KeyValuePair<ServiceStatisticInterval, TimeSpan>(ServiceStatisticInterval.LastHour, TimeSpan.FromHours(1)),
                new KeyValuePair<ServiceStatisticInterval, TimeSpan>(ServiceStatisticInterval.Last6Hours, TimeSpan.FromHours(6)),
                new KeyValuePair<ServiceStatisticInterval, TimeSpan>(ServiceStatisticInterval.Last12Hours, TimeSpan.FromHours(12)),
                new KeyValuePair<ServiceStatisticInterval, TimeSpan>(ServiceStatisticInterval.Last24Hours, TimeSpan.FromHours(24)),
                new KeyValuePair<ServiceStatisticInterval, TimeSpan>(ServiceStatisticInterval.LastWeek, TimeSpan.FromDays(7))
            };

        public CServiceResponse<ServiceStatistics> GetServiceStatistics()
        {
            try
            {
                ServiceStatistics stats = new ServiceStatistics();

                DateTime timestamp = DateTime.UtcNow;

                IEnumerable<CSession> sessions = CClientAuthentication.GetAllSessions();

                stats.TotalSessions = sessions.Count();

                stats.UserStatistics.Add(new UserStatistic(UserStatisticType.Premium, sessions.Count(p => p.ActualPremiumStatus)));
                stats.UserStatistics.Add(new UserStatistic(UserStatisticType.Regular, sessions.Count(p => !p.ActualPremiumStatus)));

                foreach (KeyValuePair<ServiceStatisticInterval, TimeSpan> kvp in _sessionStatisticTimespans)
                {
                    stats.SessionStatistics.Add(new SessionStatistic(kvp.Key, sessions.Count(p => p.DateLastActive >= DateTime.UtcNow - kvp.Value), timestamp));
                }

                return new CServiceResponse<ServiceStatistics>(EServiceResponseStatus.Successful, stats);

            }
            catch (Exception ex)
            {
                return new CServiceResponse<ServiceStatistics>(EServiceResponseStatus.UnknownException, ex.Message);
            }

        }

        public Stream GetAddOnDump(int id)
        {
            WebOperationContext.Current.OutgoingResponse.ContentType = "text/html";

            CAddOn addon = CAddOnCache.Instance.GetCachedAddOn(id);
            if (addon == null)
            {
                return new MemoryStream(System.Text.Encoding.UTF8.GetBytes("Unauthorized access"));

            }
            else
            {
                string response = addon.DumpAllProperties().Replace(Environment.NewLine, "<br>");
                return new MemoryStream(System.Text.Encoding.UTF8.GetBytes(response));
            }
        }

        public string ResetSingleAddonCache(int id)
        {

            if (!CAddOnCache.Instance.IsCacheBuilt)
            {
                return "Addon cache cannot be reset: Cache is not yet built.";
            }

            if (CAddOnCache.Instance.IsCacheUpdating)
            {
                return "Addon cache cannot be reset: Cache is currently updating.";
            }

            try
            {
                CAddOnCache.Instance.ResetSingleAddonCache(id);
                return "Addon cache will be reset.";
            }
            catch (Exception ex)
            {
                return "Addon cache cannot be reset: Exception Occurred. Details: " + ex.GetExceptionDetails();
            }

        }

        public string ResetAllAddonCache()
        {

            if (!CAddOnCache.Instance.IsCacheBuilt)
            {
                return "Addon cache cannot be reset: Cache is not yet built.";
            }

            if (CAddOnCache.Instance.IsCacheUpdating)
            {
                return "Addon cache cannot be reset: Cache is currently updating.";
            }

            CAddOnCache.Instance.ResetCache();

            return "Cache will now be reset.";
        }

        public List<AddonInstallCount> GetAddonInstallCounts()
        {
            return CUsageReportingCache.Instance.GetInstallCounts();
        }

        public string GetChangeLog(int addonID, int fileID)
        {
            CAddOn addon = CAddOnCache.Instance.GetCachedAddOn(addonID);
            if (addon == null)
            {
                return null;
            }

            CAddOnFile file = null;
            addon.Files.TryGetValue(fileID, out file);

            if (file != null)
            {
                //return file.Changelog;
                return file.GetChangeLog();
            }
            else
            {
                return null;
            }

        }

        public string v2GetChangeLog(int addonID, int fileID)
        {
            return GetChangeLog(addonID, fileID);
        }

        public string GetAddOnDescription(int id)
        {
            CAddOn addon = CAddOnCache.Instance.GetCachedAddOn(id);
            if (addon == null)
            {
                return null;
            }
            return addon.FullDescription;
        }

        public string v2GetAddOnDescription(int id)
        {
            return GetAddOnDescription(id);
        }

        public CAddOnFile GetAddOnFile(int addonID, int fileID)
        {
            CAddOn addon = CAddOnCache.Instance.GetCachedAddOn(addonID);
            if (addon == null)
            {
                return null;
            }

            CAddOnFile file = null;
            addon.Files.TryGetValue(fileID, out file);
            return file;
        }

        public List<CAddOn> GetAddOns(int[] ids)
        {
            List<CAddOn> list = new List<CAddOn>();
            foreach (int id in ids)
            {
                CAddOn addon = CAddOnCache.Instance.GetCachedAddOn(id);
                if (addon != null)
                {
                    list.Add(addon);
                }
                else
                {
                    Logger.Log("GetAddOns - Addon Not Found: {0}", ELogLevel.Debug, id);
                }
            }
            return list;
        }

        public List<CAddOn> v2GetAddOns(int[] ids)
        {
            return GetAddOns(ids);
        }

        public CFingerprintMatchResult GetFingerprintMatches(long[] fingerprints)
        {
            return CFingerprintCache.Instance.GetMatches(fingerprints);
        }

        public CFingerprintMatchResult v2GetFingerprintMatches(long[] fingerprints)
        {
            return GetFingerprintMatches(fingerprints);
        }

        public List<CFuzzyMatch> GetFuzzyMatches(int gameID, CFolderFingerprint[] folderFingerprints)
        {

            return CFingerprintCache.Instance.GetFuzzyMatches(gameID, folderFingerprints);
        }

        public CDownloadToken GetDownloadToken(int fileID)
        {
            return new CDownloadToken(this.CurrentIPAddress);
        }

        public CDownloadToken GetSecureDownloadToken(int fileID, int userID, bool hasPremium, int subscriptionToken)
        {
            if (CClientAuthentication.GetSubscriptionToken(userID, hasPremium) != subscriptionToken)
            {
                var subCode = new FaultCode("FailedAuthentication");
                //var faultCode = FaultCode.CreateSenderFaultCode(subCode);
                int statusCode = (int)EAuthenticationStatus.SubscriptionMismatch;
                var faultReason = new FaultReason(statusCode.ToString());
                throw new FaultException(faultReason, subCode);
            }
            return new CDownloadToken(this.CurrentIPAddress);
        }

        public CRepositoryMatch GetRepositoryMatchFromSlug(string gameSlug, string addonSlug)
        {
            return CAddOnCache.Instance.GetRepositoryMatchFromSlug(gameSlug, addonSlug);
        }

        public List<CAddOnFile> GetAddOnLatestFiles(int addonID)
        {
            CAddOn addon = CAddOnCache.Instance.GetCachedAddOn(addonID);
            if (addon == null)
            {
                return null;
            }

            return addon.LatestFiles;
        }

        public string CurrentIPAddress
        {
            get
            {
                string ipAddress = null;
                OperationContext context = OperationContext.Current;

                try
                {
                    WebOperationContext webContext = WebOperationContext.Current;
                    ipAddress = webContext.IncomingRequest.Headers["X-Forwarded-For"];
                }
                catch
                {

                }

                if (ipAddress.IsNullOrEmpty())
                {
                    MessageProperties properties = context.IncomingMessageProperties;
                    RemoteEndpointMessageProperty endpoint = properties[RemoteEndpointMessageProperty.Name] as RemoteEndpointMessageProperty;
                    ipAddress = endpoint.Address;
                }

                return ipAddress;
            }
        }

        #region Addon Sync (Premium Only)

        public CServiceResponse<List<CSyncedGameInstance>> GetSyncProfile()
        {
            CSession session = CClientAuthentication.CurrentSession;
            try
            {
                return CSyncCache.Instance.GetSyncProfile(session.UserID);
            }
            catch (Exception ex)
            {
                Logger.Log("CreateSyncGroup - Unhandled Exception! Details: {0}", ELogLevel.Error, ex.GetExceptionDetails());
                return new CServiceResponse<List<CSyncedGameInstance>>(EServiceResponseStatus.UnknownException, ex.Message);
            }
        }

        public CServiceResponse<CSyncedGameInstance> CreateSyncGroup(string instanceName, int gameID, string computerName, string instanceGUID, string instanceLabel)
        {
            CSession session = CClientAuthentication.CurrentSession;

            try
            {
                return CSyncCache.Instance.CreateSyncGroup(session.UserID, gameID, instanceName, computerName, instanceGUID, instanceLabel);
            }
            catch (Exception ex)
            {
                Logger.Log("CreateSyncGroup - Unhandled Exception! Details: {0}", ELogLevel.Error, ex.GetExceptionDetails());
                return new CServiceResponse<CSyncedGameInstance>(EServiceResponseStatus.UnknownException, ex.Message);
            }

        }

        public CServiceResponse JoinSyncGroup(int instanceID, string computerName, string instanceGUID, string instanceLabel)
        {
            CSession session = CClientAuthentication.CurrentSession;

            try
            {
                return CSyncCache.Instance.JoinSyncGroup(session.UserID, instanceID, computerName, instanceGUID, instanceLabel);
            }
            catch (Exception ex)
            {
                Logger.Log("JoinSyncGroup - Unhandled Exception! Details: {0}", ELogLevel.Error, ex.GetExceptionDetails());
                return new CServiceResponse(EServiceResponseStatus.UnknownException, ex.Message);
            }

        }

        public CServiceResponse LeaveSyncGroup(int instanceID, int computerID, string instanceGUID)
        {
            CSession session = CClientAuthentication.CurrentSession;
            try
            {
                return CSyncCache.Instance.LeaveSyncGroup(session.UserID, instanceID, computerID, instanceGUID);
            }
            catch (Exception ex)
            {
                Logger.Log("LeaveSyncGroup - Unhandled Exception! Details: {0}", ELogLevel.Error, ex.GetExceptionDetails());
                return new CServiceResponse(EServiceResponseStatus.UnknownException, ex.Message);
            }
        }

        public CServiceResponse SaveSyncSnapshot(int instanceID, CSyncedAddon[] syncedAddons)
        {
            CSession session = CClientAuthentication.CurrentSession;

            try
            {
                return CSyncCache.Instance.SaveSyncSnapshot(session.UserID, instanceID, syncedAddons);
            }
            catch (Exception ex)
            {
                Logger.Log("SaveSyncSnapshot - Unhandled Exception! Details: {0}", ELogLevel.Error, ex.GetExceptionDetails());
                return new CServiceResponse(EServiceResponseStatus.UnknownException, ex.Message);
            }

        }

        public CServiceResponse SaveSyncTransactions(int instanceID, CSyncTransaction[] transactions)
        {
            CSession session = CClientAuthentication.CurrentSession;

            try
            {
                return CSyncCache.Instance.SaveSyncTransactions(session.UserID, instanceID, transactions);
            }
            catch (Exception ex)
            {
                Logger.Log("SaveSyncTransactions - Unhandled Exception! Details: {0}", ELogLevel.Error, ex.GetExceptionDetails());
                return new CServiceResponse(EServiceResponseStatus.UnknownException, ex.Message);
            }
        }

        #endregion

        #region Saved Game Sync

        public CServiceResponse<List<CSavedGame>> GetSavedGames()
        {
            var session = CClientAuthentication.CurrentSession;

            try
            {
                if (CSavedGameSyncCache.Instance.RestrictionLevel == ESavedGameRestrictionLevel.Disabled)
                {
                    return new CServiceResponse<List<CSavedGame>>(EServiceResponseStatus.Successful, new List<CSavedGame>());
                }
                else
                {
                    return CSavedGameSyncCache.Instance.GetSavedGames(session.UserID);
                }
            }
            catch (Exception exc)
            {
                Logger.Log("GetSavedGames - Unhandled Exceprion! Details: {0}", ELogLevel.Error, exc.GetExceptionDetails());
                return new CServiceResponse<List<CSavedGame>>(EServiceResponseStatus.UnknownException, exc.Message);
            }
        }

        public CServiceResponse DeleteSavedGame(int savedGameId)
        {
            var session = CClientAuthentication.CurrentSession;

            try
            {
                return CSavedGameSyncCache.Instance.DeleteSavedGame(session.UserID, savedGameId);
            }
            catch (Exception exc)
            {
                Logger.Log("DeleteSavedGame - Unhandled Exceprion! Details: {0}", ELogLevel.Error, exc.GetExceptionDetails());
                return new CServiceResponse(EServiceResponseStatus.UnknownException, exc.Message);
            }
        }

        public CServiceResponse DeleteSavedGameRevision(int savedGameId, int revisionId)
        {
            var session = CClientAuthentication.CurrentSession;

            try
            {
                return CSavedGameSyncCache.Instance.DeleteSavedGameRevision(session.UserID, savedGameId, revisionId);
            }
            catch (Exception exc)
            {
                Logger.Log("DeleteSavedGameRevision - Unhandled Exceprion! Details: {0}", ELogLevel.Error, exc.GetExceptionDetails());
                return new CServiceResponse(EServiceResponseStatus.UnknownException, exc.Message);
            }
        }

        public CServiceResponse SetSavedGameStatus(int savedGameId, ESavedGameStatus status)
        {
            var session = CClientAuthentication.CurrentSession;

            try
            {
                return CSavedGameSyncCache.Instance.SetSavedGameStatus(session.UserID, savedGameId, status);
            }
            catch (Exception exc)
            {
                Logger.Log("SetSavedGameStatus - Unhandled Exceprion! Details: {0}", ELogLevel.Error, exc.GetExceptionDetails());
                return new CServiceResponse(EServiceResponseStatus.UnknownException, exc.Message);
            }
        }

        public CServiceResponse SetSavedGameName(int savedGameId, string name)
        {
            var session = CClientAuthentication.CurrentSession;

            try
            {
                return CSavedGameSyncCache.Instance.SetSavedGameName(session.UserID, savedGameId, name);
            }
            catch (Exception exc)
            {
                Logger.Log("SetSavedGameName - Unhandled Exceprion! Details: {0}", ELogLevel.Error, exc.GetExceptionDetails());
                return new CServiceResponse(EServiceResponseStatus.UnknownException, exc.Message);
            }
        }

        public CServiceResponse SetSavedGameDescription(int savedGameId, string description)
        {
            var session = CClientAuthentication.CurrentSession;

            try
            {
                return CSavedGameSyncCache.Instance.SetSavedGameDescription(session.UserID, savedGameId, description);
            }
            catch (Exception exc)
            {
                Logger.Log("SetSavedGameDescription - Unhandled Exceprion! Details: {0}", ELogLevel.Error, exc.GetExceptionDetails());
                return new CServiceResponse(EServiceResponseStatus.UnknownException, exc.Message);
            }
        }

        public CServiceResponse SetSavedGameDefaultRevision(int savedGameId, int revisionId)
        {
            var session = CClientAuthentication.CurrentSession;

            try
            {
                return CSavedGameSyncCache.Instance.SetSavedGameDefaultRevision(session.UserID, savedGameId, revisionId);
            }
            catch (Exception exc)
            {
                Logger.Log("SetSavedGameDefaultRevision - Unhandled Exceprion! Details: {0}", ELogLevel.Error, exc.GetExceptionDetails());
                return new CServiceResponse(EServiceResponseStatus.UnknownException, exc.Message);
            }
        }

        public CServiceResponse SetSavedGameFavoriteRevision(int savedGameId, int revisionId)
        {
            var session = CClientAuthentication.CurrentSession;

            try
            {
                return CSavedGameSyncCache.Instance.SetSavedGameFavoriteRevision(session.UserID, savedGameId, revisionId);
            }
            catch (Exception exc)
            {
                Logger.Log("SetSavedGameFavoriteRevision - Unhandled Exceprion! Details: {0}", ELogLevel.Error, exc.GetExceptionDetails());
                return new CServiceResponse(EServiceResponseStatus.UnknownException, exc.Message);
            }
        }

        public CServiceResponse<CSavedGameConstraints> GetSavedGameConstraints()
        {
            return new CServiceResponse<CSavedGameConstraints>(EServiceResponseStatus.Successful, new CSavedGameConstraints(0, 0));
        }

        public CServiceResponse<ESavedGameRestrictionLevel> GetSavedGameRestrictionLevel()
        {
            try
            {
                return new CServiceResponse<ESavedGameRestrictionLevel>(EServiceResponseStatus.Successful, CSavedGameSyncCache.Instance.RestrictionLevel);
            }
            catch (Exception exc)
            {
                Logger.Log("GetSavedGameRestrictionLevel - Unhandled Exceprion! Details: {0}", ELogLevel.Error, exc.GetExceptionDetails());
                return new CServiceResponse<ESavedGameRestrictionLevel>(EServiceResponseStatus.UnknownException, exc.Message);
            }
        }

        public CServiceResponse SetSavedGameRestrictionLevel(ESavedGameRestrictionLevel restrictionLevel)
        {
            try
            {
                CSavedGameSyncCache.Instance.RestrictionLevel = restrictionLevel;
                return new CServiceResponse(EServiceResponseStatus.Successful);
            }
            catch (Exception exc)
            {
                Logger.Log("SetSavedGameRestrictionLevel - Unhandled Exceprion! Details: {0}", ELogLevel.Error, exc.GetExceptionDetails());
                return new CServiceResponse(EServiceResponseStatus.UnknownException, exc.Message);
            }
        }

        public CServiceResponse UploadAvailableForUser()
        {
            var session = CClientAuthentication.CurrentSession;

            try
            {
                return CloudUserCache.Instance.UserOrSlotsAvailable(session.UserID);
            }
            catch (Exception exc)
            {
                Logger.Log("UploadAvailableForUser - Unknown Exception. Details: {0}", ELogLevel.Error, exc.GetExceptionDetails());
                return new CServiceResponse(EServiceResponseStatus.UnknownException, exc.GetExceptionDetails());
            }
        }
        #endregion

        public bool SaveHardwareProfile(CHardwareProfile profile)
        {
            try
            {
                return CHardwareReportCache.Instance.SaveReport(CClientAuthentication.CurrentSession.UserID, profile);
            }
            catch (Exception ex)
            {
                Logger.Log("SaveUsageProfile - Unhandled Exception! Details: {0}", ELogLevel.Error, ex.GetExceptionDetails());
                return false;
            }
        }

        public bool SaveUsageProfile(CUsageProfile profile)
        {

            CSession session = CClientAuthentication.CurrentSession;

            try
            {
                return CUsageReportingCache.Instance.SaveReport(session.UserID, profile);
            }
            catch (Exception ex)
            {
                Logger.Log("SaveUsageProfile - Unhandled Exception! Details: {0}", ELogLevel.Error, ex.GetExceptionDetails());
                return false;
            }
        }

        public CSession GetCurrentSession()
        {
            return CClientAuthentication.RefreshedSession;
        }

        public CSession v2GetCurrentSession()
        {
            return CClientAuthentication.RefreshedSession;
        }

        public List<CNotification> GetNotifications(int notificationID)
        {
            return CNotificationCache.Instance.GetNotifications(notificationID);
        }

        public CCampaign GetActiveCampaign()
        {
            //CCampaign frCampaign = CCampaignCache.Instance.GetActiveCampaign(IPAddress.Parse("207.98.195.160"));
            IPAddress ipAddress;
            if (IPAddress.TryParse(this.CurrentIPAddress, out ipAddress))
            {
                return CCampaignCache.Instance.GetActiveCampaign(ipAddress);
            }

            return null;
        }

        public string GetThemePackHash()
        {
            return CCampaignCache.Instance.ThemePackHash;
        }

        public string HealthCheck()
        {
            using (SqlConnection conn = new SqlConnection(ConfigurationManager.ConnectionStrings["RoamingDBRadon"].ConnectionString))
            {
                conn.Open();
            }

            return "Success";
        }

#if DEBUG
        public string TestDatababaseReadSpeed()
        {
            string connectiongString = ConfigurationManager.ConnectionStrings["RoamingDBRadon"].ConnectionString;
            DateTime startTime = DateTime.UtcNow;
            int counter = 0;
            using (SqlConnection conn = new SqlConnection(connectiongString))
            {
                conn.Open();
                var command = conn.CreateCommand();
                command.CommandText = "curseService_GetProjectFileGameVersions";
                command.CommandType = CommandType.StoredProcedure;
                command.Parameters.Add("LastUpdated", SqlDbType.DateTime).Value = new DateTime(1979, 5, 17); ;


                using (SqlDataReader gameVersionReader = command.ExecuteReader())
                {
                    while (gameVersionReader.Read())
                    {
                        ++counter;
                        int fileId = gameVersionReader.GetInt32(gameVersionReader.GetOrdinal("ProjectFileID"));
                        string versionName = gameVersionReader.GetString(gameVersionReader.GetOrdinal("Name"));

                    }
                }
            }
            return "Read " + counter.ToString("###,##0") + " addon file game version mappings in " + (DateTime.UtcNow - startTime).TotalSeconds.ToString("###,##0.00") + " seconds from: " + connectiongString;
        }
#endif

    }


}
