﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Configuration;
using System.Data.SqlClient;
using System.Data;
using Curse.ClientService.Models;

namespace Curse.ClientService
{
    public class CProxyRequestCache
    {
        private static readonly CProxyRequestCache _instance = new CProxyRequestCache();
        private string _databaseConnectionString = null;
        private int _nodeID;


        public CProxyRequestCache()
        {
            _databaseConnectionString = ConfigurationManager.ConnectionStrings["ClientService"].ConnectionString;
            try
            {
                RegisterNode();
            }
            catch (Exception ex)
            {
                Logger.Log("Unable to register node! Message: {0}", ELogLevel.Error, ex.Message);
            }
        }

        public void Initialize() { }
        

        public static CProxyRequestCache Instance
        {
            get
            {
                return _instance;
            }
        }

        private void RegisterNode()
        {
            using (SqlConnection conn = new SqlConnection(_databaseConnectionString))
            {
                conn.Open();
                SqlCommand command = conn.CreateCommand();
                command.CommandText = "select [ID] from ServerNode where [Name] = @Name";
                SqlParameter param = command.Parameters.Add("@Name", SqlDbType.NVarChar);
                param.Value = System.Environment.MachineName;
                object nodeID = command.ExecuteScalar();
                if (nodeID != null)
                {
                    _nodeID = (int)nodeID;
                }

                command.CommandText = "insert into ServerNode(Name) output inserted.ID values(@Name)";
                _nodeID = (int)command.ExecuteScalar();

            }
        }

        
        //private Dictionary<int, CProxyRequest> 

        public void AddRequest(string url)
        {
            using (SqlConnection conn = new SqlConnection(_databaseConnectionString))
            {
                conn.Open();
                SqlCommand command = conn.CreateCommand();
                command.CommandText = "insert into ProxyRequest(Status, Url, SouceNode) output inserted.ID values(1, @Url, @SourceNode)";

                // Url
                SqlParameter param = command.Parameters.Add("@Url", SqlDbType.NVarChar);
                param.Value = url;

                // Source Node
                param = command.Parameters.Add("@SourceNode", SqlDbType.TinyInt);
                param.Value = _nodeID;

                int requestID = (int)command.ExecuteScalar();
            }
        }

    }
}
