﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Curse.AddOns;
using System.Data.SqlClient;
using System.Data;
using System.Runtime.Serialization.Formatters.Binary;
using System.IO;
using System.Drawing;

namespace Curse.ClientService.Extensions
{
    public static class CCategoryExtension
    {
        public static void SetFromDataReader(this CCategory category, SqlDataReader pReader)
        {
            category.Id = (int)pReader["ID"];
            category.Name = (string)pReader["Name"];

            if (pReader["ParentCategoryId"] != System.DBNull.Value)
            {
                category.ParentId = (int)pReader["ParentCategoryId"];
            }

            category.Slug = (string)pReader["Slug"];

            try
            {
                if (pReader["AvatarID"] != System.DBNull.Value)
                {
                    int avatarID = (int)pReader["AvatarID"];
                    CAvatar avatar = CAvatarCache.Instance.Avatars.FirstOrDefault(p => p.Id == avatarID);
                    if (avatar != null)
                    {
                        category.Icon = avatar.Icon;
                    }
                }
            }
            catch (Exception exc)
            {
                Logger.Log("We got's issues!!!", ELogLevel.Error, exc.InnerException.Message + exc.InnerException.StackTrace);
            }
        }
    }
}
