﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Configuration;
using System.Threading;
using System.Net;
using System.IO;
using ICSharpCode.SharpZipLib.Zip;
using System.Text.RegularExpressions;
using System.Data;
using System.Data.SqlClient;

namespace Curse.ClientService.GeoCoding
{
    public static class IPDatabaseUpdater
    {

        private static readonly Regex _csvSplit;
        //private const string DownloadUrl = "http://www.analysespider.com/data/ip2country/ip2country_csv.zip";
        private const string DownloadUrl = "http://www.maxmind.com/app/download_new?edition_id=108&suffix=zip&license_key=2bPFVu3togLd";
        private const string ExtractedFilename = "ip2country.csv";
        private const string Username = "accounting@curse.com";
        private const string Password = "7u1y3e8u";
        private static string _databaseConnectionString = null;


        static IPDatabaseUpdater()
        {
            _csvSplit = new Regex(",(?!(?:[^\",]|[^\"],[^\"])+\")", RegexOptions.Compiled);
            _databaseConnectionString = ConfigurationManager.ConnectionStrings["ClientService"].ConnectionString;
        }
        public static void Initialize()
        {
            // Only run this on the 'Job' machine
            if ((System.Environment.MachineName.ToLower() != ConfigurationManager.AppSettings["JobMachineName"].ToLower()))
            {
                return;
            }

            new Thread(UpdateIPDatabaseThread) { IsBackground = true }.Start();
        }

        private static void UpdateIPDatabaseThread()
        {
            while (true)
            {
                try
                {
                    UpdateIPDatabase();
                }
                catch (Exception ex)
                {
                    Logger.Log(ELogLevel.Error, "Unable to update IP datbase: {0}", ex.Message);
                }

                Thread.Sleep(TimeSpan.FromHours(12));
            }
        }

        private static void UpdateIPDatabase()
        {
            Logger.Log("IP Database Update Started", ELogLevel.Info);
            
            // First, download the CSV
            CredentialCache credentialCache = new CredentialCache();
            credentialCache.Add(new Uri(DownloadUrl), "Basic", new NetworkCredential(Username, Password));
            
            HttpWebRequest webRequest = (HttpWebRequest)WebRequest.Create(DownloadUrl);
            WebClient client = new WebClient();
            client.Proxy = null;
            client.Credentials = credentialCache;
            string tempfile = Path.Combine(Path.GetTempPath(), Utility.UniqueNumber + ".zip");
            client.DownloadFile(DownloadUrl,  tempfile);

            string unzipPath = Path.Combine(Path.GetTempPath(), "IPDatabase");

            FastZip unzipper = new FastZip();
            unzipper.ExtractZip(tempfile, unzipPath, FastZip.Overwrite.Always, null, null, null, false);
            
            string filePath = Path.Combine(unzipPath, ExtractedFilename);

            string fileContents = null;
            using (StreamReader reader = new StreamReader(filePath))
            {
                fileContents = reader.ReadToEnd();
            }

            // File format is: "begin_ip","end_ip","begin_num","end_num","countryCode","countryName"
            Regex newLineRegex = new Regex("\r\n", RegexOptions.Compiled);

            // Split the file contents by new line
            string[] lines = newLineRegex.Split(fileContents);

            // Get a data table for bulk copying our data
            DataTable dt = GenerateIPTable();
            dt.BeginLoadData();

            for (int i=1;i<lines.Length;i++)
            {
                string line = lines[i];
                string[] fields = _csvSplit.Split(line);
                
                if (fields.Length != 6)
                {
                    continue;
                }

                // Remove the quotes
                for (int j = 0; j < fields.Length; j++)
                {
                    fields[j] = fields[j].Replace("\"", string.Empty);
                }

                string beginIP = fields[2];
                string endIp = fields[3];
                string country = fields[4];

                DataRow row = dt.NewRow();
                row[0] = country;
                row[1] = Int64.Parse(beginIP);
                row[2] = Int64.Parse(endIp);

                dt.Rows.Add(row);
            }


            using (SqlConnection conn = new SqlConnection(_databaseConnectionString))
            {
                conn.Open();

                SqlTransaction txn = conn.BeginTransaction();

                SqlCommand cmd = conn.CreateCommand();
                cmd.Transaction = txn;

                cmd.CommandText = "truncate table CountryIPRange";
                cmd.ExecuteNonQuery();

                using (SqlBulkCopy bulk = new SqlBulkCopy(conn, SqlBulkCopyOptions.TableLock, txn))
                {
                    bulk.DestinationTableName = "CountryIPRange";
                    bulk.WriteToServer(dt);
                }

                txn.Commit();
            }
            CCampaignCache.Instance.PopulateGeoData();
            Logger.Log("IP Database Update Finished", ELogLevel.Info);
        }

        private static DataTable GenerateIPTable()
        {
            DataTable dt = new DataTable("CountryIPRange");
            dt.Columns.Add("CountryCode", typeof(string));
            dt.Columns.Add("IPRangeStart", typeof(Int64));
            dt.Columns.Add("IPRangeEnd", typeof(Int64));
            return dt;
        }
    }
}
