﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.Text;
using Curse.ClientService.com.curse.auth;
using Curse.ClientService.Models;
using System.ServiceModel.Web;
using System.Net.Security;

namespace Curse.ClientService
{
    // NOTE: If you change the interface name "ICClientRegistrationService" here, you must also update the reference to "ICClientRegistrationService" in Web.config.
    [ServiceContract(Name = "CClientBackupService", Namespace = "http://clientservice.curse.com/", ProtectionLevel = ProtectionLevel.None)]
    public interface IClientBackupService
    {
        [OperationContract(Action = "SaveUserBackup", IsOneWay = true)]
        [RequiresAuthentication(AccessLevel.PremiumSubscription)]
        void SaveUserBackup(CUserBackupMessage request);

        [OperationContract(Action = "SyncSavedGame", IsOneWay = true)]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        void SyncSavedGame(CSavedGameSyncMessage request);

        [OperationContract(Action = "AddRevision", IsOneWay = true)]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        void AddRevision(CSavedGameSyncMessage request);
    }
}
