﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.Text;
using Curse.ClientService.com.curse.auth;
using Curse.ClientService.Models;
using System.ServiceModel.Web;

namespace Curse.ClientService
{
    // NOTE: If you change the interface name "ICClientRegistrationService" here, you must also update the reference to "ICClientRegistrationService" in Web.config.
    [ServiceContract(Name = "CClientRegistrationService", Namespace = "http://clientservice.curse.com/")]
    public interface IClientRegistrationService
    {
        [OperationContract]        
        DateTime GetCacheFileDate(ECacheFileType type);

        [OperationContract]
        bool IsUsernameAvailable(string username);

        [OperationContract]
        CRegisterUserResult RegisterUser(string username,
                                        string password,
                                        string firstname,
                                        string lastname,
                                        string birthdate,
                                        string gender,
                                        string country,
                                        string region,
                                        string city,
                                        string email,
                                        bool newsletter);
    }
}
