﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.ServiceModel.Web;
using System.Text;
using System.Net.Security;

using Curse.AddOns;
using Curse.ClientService.Models;
using System.IO;
using Curse.ClientService.AdminModels;
using System.Web.Script.Services;

namespace Curse.ClientService
{
    [ServiceContract(Name = "CClientService", Namespace = "http://clientservice.curse.com/", ProtectionLevel=ProtectionLevel.None)]
    public interface IClientService
    {

        #region Authentication and Usage Reporting

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/GetCurrentSession", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        CSession GetCurrentSession();

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/v2GetCurrentSession", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Json)]
        CSession v2GetCurrentSession();

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        bool SaveHardwareProfile(CHardwareProfile profile);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/SaveUsageProfile", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        bool SaveUsageProfile(CUsageProfile profile);
       
        #endregion

        #region Addons

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/GetAddOn?id={id}", Method = "POST")]
        CAddOn GetAddOn(int id);
        
        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/GetRepositoryMatchFromSlug?gameSlug={gameSlug}&addonSlug={addonSlug}", Method = "POST")]
        CRepositoryMatch GetRepositoryMatchFromSlug(string gameSlug, string addonSlug);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/GetChangeLog?addonID={addonID}&fileID={fileID}", Method = "POST")]
        string GetChangeLog(int addonID, int fileID);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/v2GetChangeLog?addonID={addonID}&fileID={fileID}", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Json)]
        string v2GetChangeLog(int addonID, int fileID);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/GetAddOnDescription?id={id}", Method = "POST")]
        string GetAddOnDescription(int id);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/v2GetAddOnDescription?id={id}", Method = "POST", BodyStyle = WebMessageBodyStyle.Bare, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Json)]
        string v2GetAddOnDescription(int id);
        
        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/GetAddOnFile?addonID={addonID}&fileID={fileID}", Method = "POST")]
        CAddOnFile GetAddOnFile(int addonID, int fileID);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/GetAddOns", Method = "POST", BodyStyle = WebMessageBodyStyle.Bare, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        List<CAddOn> GetAddOns(int[] ids);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/v2GetAddOns", Method = "POST", BodyStyle = WebMessageBodyStyle.Bare, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Json)]
        List<CAddOn> v2GetAddOns(int[] ids);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/GetFingerprintMatches", Method = "POST", BodyStyle = WebMessageBodyStyle.Bare, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        CFingerprintMatchResult GetFingerprintMatches(long[] fingerprints);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/v2GetFingerprintMatches", Method = "POST", BodyStyle = WebMessageBodyStyle.Bare, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Json)]
        CFingerprintMatchResult v2GetFingerprintMatches(long[] fingerprints);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/GetFuzzyMatches", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        List<CFuzzyMatch> GetFuzzyMatches(int gameID, CFolderFingerprint[] folderFingerprints);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/GetDownloadToken?fileid={fileid}", Method = "POST")]
        CDownloadToken GetDownloadToken(int fileID);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/GetSecureDownloadToken", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        CDownloadToken GetSecureDownloadToken(int fileID, int userID, bool hasPremium, int subscriptionToken);

        #endregion              

        #region Notifications

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        List<CNotification> GetNotifications(int notificationID);

        #endregion

        #region Advertising Campaigns

        [OperationContract]
        //[RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/GetActiveCampaign", Method = "GET")]
        CCampaign GetActiveCampaign();

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/GetThemePackHash", Method = "GET")]
        string GetThemePackHash();

        #endregion

        #region Addon Sync (Premium Only)

        [OperationContract]
        [RequiresAuthentication(AccessLevel.PremiumPromotion)]
        CServiceResponse<List<CSyncedGameInstance>> GetSyncProfile();

        [OperationContract]
        [RequiresAuthentication(AccessLevel.PremiumPromotion)]
        [WebInvoke(UriTemplate = "/CreateSyncGroup", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        CServiceResponse<CSyncedGameInstance> CreateSyncGroup(string instanceName, int gameID, string computerName, string instanceGUID, string instanceLabel);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.PremiumPromotion)]
        [WebInvoke(UriTemplate = "/JoinSyncGroup", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        CServiceResponse JoinSyncGroup(int instanceID, string computerName, string instanceGUID, string instanceLabel);       

        [OperationContract]
        [RequiresAuthentication(AccessLevel.PremiumPromotion)]
        [WebInvoke(UriTemplate = "/LeaveSyncGroup", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        CServiceResponse LeaveSyncGroup(int instanceID, int computerID, string instanceGUID);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.PremiumPromotion)]
        [WebInvoke(UriTemplate = "/SaveSyncSnapshot", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        CServiceResponse SaveSyncSnapshot(int instanceID, CSyncedAddon[] syncedAddons);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.PremiumPromotion)]
        [WebInvoke(UriTemplate = "/SaveSyncTransactions", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        CServiceResponse SaveSyncTransactions(int instanceID, CSyncTransaction[] transactions);

        #endregion

        #region Saved Game Sync
        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/GetSavedGames", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        CServiceResponse<List<CSavedGame>> GetSavedGames();

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/DeleteSavedGame", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        CServiceResponse DeleteSavedGame(int savedGameId);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/DeleteSavedGameRevision", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        CServiceResponse DeleteSavedGameRevision(int savedGameId, int savedGameRevisionId);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/SetSavedGameStatus", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        CServiceResponse SetSavedGameStatus(int savedGameId, ESavedGameStatus status);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/SetSavedGameName", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        CServiceResponse SetSavedGameName(int savedGameId, string name);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/SetSavedGameDescription", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        CServiceResponse SetSavedGameDescription(int savedGameId, string description);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/SetSavedGameDefaultRevision", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        CServiceResponse SetSavedGameDefaultRevision(int savedGameId, int revisionId);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/SetSavedGameFavoriteRevision", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        CServiceResponse SetSavedGameFavoriteRevision(int savedGameId, int revisionId);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/GetSavedGameConstraints", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        CServiceResponse<CSavedGameConstraints> GetSavedGameConstraints();

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/GetSavedGameRestrictionLevel", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        CServiceResponse<ESavedGameRestrictionLevel> GetSavedGameRestrictionLevel();

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/UploadAvailableForUser", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        CServiceResponse UploadAvailableForUser();
        #endregion

        #region Admin Only

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Administrator)]
        Stream GetAddOnDump(int id);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Administrator)]
        CServiceResponse<ServiceStatistics> GetServiceStatistics();

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Administrator)]        
        string ResetAllAddonCache();

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Administrator)]        
        string ResetSingleAddonCache(int id);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Administrator)]
        CServiceResponse SetSavedGameRestrictionLevel(ESavedGameRestrictionLevel restrictionLevel);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.ApiKey)]
        [WebInvoke(UriTemplate = "/GetAddonInstallCounts", Method = "GET", ResponseFormat = WebMessageFormat.Json)]        
        List<AddonInstallCount> GetAddonInstallCounts();

        #endregion

      

        #region Tests

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Anonymous)]
        [WebInvoke(UriTemplate = "/HealthCheck", Method = "GET")]
        string HealthCheck();

#if DEBUG
        [OperationContract]
        [RequiresAuthentication(AccessLevel.Anonymous)]
        [WebInvoke(UriTemplate = "/TestDatabaseReadSpeed", Method = "GET")]
        string TestDatababaseReadSpeed();
#endif

        #endregion
    }
}
