﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Configuration;
using System.Threading;
using System.Data.SqlClient;
using System.Data;

namespace Curse.ClientService.AddOns
{
    public class CAddOnCache
    {
     
        private static Dictionary<int, CAddOn> sAddOnCache = new Dictionary<int, CAddOn>();
        private static DateTime sLastQueryTime = DateTime.Parse("4/20/2009 12:00:00 AM");
        private static int sUpdateThreadInterval;
        private static Thread sUpdateThread = null;
        private static string sAddonDatabaseConnection = null;

        public static void Initialize()
        {
            sUpdateThreadInterval = int.Parse(ConfigurationManager.AppSettings["UpdateThreadInterval"]);
            sUpdateThread = new Thread(CacheThread);
            sAddonDatabaseConnection = ConfigurationManager.ConnectionStrings["RoamingDB"].ConnectionString;
            UpdateAddOnCache();
            sUpdateThread.Start();
        }
    
        public static CAddOn GetCachedAddOn(int pId)
        {
            if (sAddOnCache.ContainsKey(pId))
            {
                return sAddOnCache[pId];
            }
            else
            {
                return null;
            }
        }

        private static void CacheThread()
        {
            Boolean aborted = false;
            while (!aborted)
            {
                Thread.Sleep(sUpdateThreadInterval);
                GC.Collect();
                try
                {
                    UpdateAddOnCache();
                }
                catch (ThreadAbortException)
                {
                    aborted = true;
                    sUpdateThread.Join(100);
                    Logger.Log(ELogLevel.Info,
                               null,
                               "Thread Abort Exception. Service shutting down.");
                }
                catch (Exception ex)
                {

                    Logger.Log(ELogLevel.Info,
                               null,
                               "Update Thread Exception: {0}", ex.Message + "\n" + ex.StackTrace);
                }
            }
        }

        private static void UpdateAddOnCache()
        {

            using (SqlConnection conn = new SqlConnection(sAddonDatabaseConnection))
            {
                try
                {
                    conn.Open();
                }
                catch (Exception)
                {
                    Logger.Log(ELogLevel.Info, "localhost", "Unable to establish connection to database:" + DateTime.Now.ToString());
                    return;
                }

                Dictionary<int, CAddOn> addOnCache = new Dictionary<int, CAddOn>(sAddOnCache);


                DateTime changeDate = sLastQueryTime.AddMinutes(-5);
                SqlCommand command = new SqlCommand("curseService_GetAddOnList", conn);
                command.CommandType = CommandType.StoredProcedure;
                command.Parameters.Add(new SqlParameter("@LastUpdated", SqlDbType.DateTime));
                command.Parameters["@LastUpdated"].Value = changeDate;

                sLastQueryTime = DateTime.UtcNow;

                // Populate the cache with recently modified addons:
                using (SqlDataReader reader = command.ExecuteReader())
                {
                    Dictionary<int, List<CIndividualFileFingerprint>> individualFingerprintCache = new Dictionary<int, List<CIndividualFileFingerprint>>();
                    Dictionary<int, List<CAddOnFile>> fileArchiveCache = new Dictionary<int, List<CAddOnFile>>();
                    Dictionary<int, List<CAddOnFileDependency>> fileDependencyCache = new Dictionary<int, List<CAddOnFileDependency>>();

                    // Get a cache of the individual fingerprints:
                    using (SqlCommand fingerprintCommand = new SqlCommand("curseService_GetAllIndividualFingerprints", conn))
                    {
                        fingerprintCommand.CommandType = CommandType.StoredProcedure;
                        fingerprintCommand.Parameters.Add(new SqlParameter("@LastUpdated", SqlDbType.DateTime));
                        fingerprintCommand.Parameters["@LastUpdated"].Value = changeDate;
                        fingerprintCommand.CommandTimeout = 300;
                        using (SqlDataReader fingerprintReader = fingerprintCommand.ExecuteReader())
                        {
                            while (fingerprintReader.Read())
                            {
                                int id = fingerprintReader.GetInt32(0);
                                int fileId = fingerprintReader.GetInt32(1);
                                long fingerprint = fingerprintReader.GetInt64(2);
                                string folder = fingerprintReader.GetString(3);
                                if (!individualFingerprintCache.ContainsKey(id))
                                {
                                    individualFingerprintCache.Add(id, new List<CIndividualFileFingerprint>());
                                }
                                individualFingerprintCache[id].Add(new CIndividualFileFingerprint(id, fileId, fingerprint, folder));
                            }
                        }
                    }

                    // Get a cache of the file dependenecies:
                    using (SqlCommand dependencyCommand = new SqlCommand("curseService_GetAllFileDependencies", conn))
                    {
                        dependencyCommand.CommandType = CommandType.StoredProcedure;
                        dependencyCommand.Parameters.Add(new SqlParameter("@LastUpdated", SqlDbType.DateTime));
                        dependencyCommand.Parameters["@LastUpdated"].Value = changeDate;
                        dependencyCommand.CommandTimeout = 300;
                        using (SqlDataReader dependencyReader = dependencyCommand.ExecuteReader())
                        {
                            while (dependencyReader.Read())
                            {
                                int fileId = dependencyReader.GetInt32(0);
                                int dependencyId = dependencyReader.GetInt32(1);
                                byte dependencyType = dependencyReader.GetByte(2);

                                if (!fileDependencyCache.ContainsKey(fileId))
                                {
                                    fileDependencyCache.Add(fileId, new List<CAddOnFileDependency>());
                                }
                                fileDependencyCache[fileId].Add(new CAddOnFileDependency(dependencyId, dependencyType));
                            }
                        }
                    }

                    // Get a cache of the file archive:
                    using (SqlCommand archiveCommand = new SqlCommand("curseService_GetAllArchivedFiles", conn))
                    {
                        archiveCommand.CommandType = CommandType.StoredProcedure;
                        archiveCommand.Parameters.Add(new SqlParameter("@LastUpdated", SqlDbType.DateTime));
                        archiveCommand.Parameters["@LastUpdated"].Value = changeDate;

                        using (SqlDataReader archiveReader = archiveCommand.ExecuteReader())
                        {
                            while (archiveReader.Read())
                            {
                                int id = archiveReader.GetInt32(0);
                                if (!fileArchiveCache.ContainsKey(id))
                                {
                                    fileArchiveCache.Add(id, new List<CAddOnFile>());
                                }
                                fileArchiveCache[id].Add(new CAddOnFile(archiveReader, true));
                            }
                        }
                    }

                    string addOnName = null;
                    Int32 addOnId = 0;
                    while (reader.Read())
                    {
                        addOnId = reader.GetInt32(reader.GetOrdinal("addon_id"));
                        addOnName = reader.GetString(reader.GetOrdinal("addon_name"));

                        if (addOnCache.ContainsKey(addOnId))
                        {
                            addOnCache[addOnId] = new CAddOn(conn, reader, individualFingerprintCache, fileArchiveCache, fileDependencyCache);
                        }
                        else
                        {
                            addOnCache.Add(addOnId, new CAddOn(conn, reader, individualFingerprintCache, fileArchiveCache, fileDependencyCache));
                        }
                    }
                }


                // Disable any deleted addons:
                command = new SqlCommand("curseService_GetDeletedAddOnList", conn);
                command.CommandType = CommandType.StoredProcedure;
                command.Parameters.Add(new SqlParameter("@LastUpdated", SqlDbType.DateTime));
                command.Parameters["@LastUpdated"].Value = changeDate;

                using (SqlDataReader reader = command.ExecuteReader())
                {
                    Int32 addOnId = 0;
                    while (reader.Read())
                    {
                        addOnId = reader.GetInt32(0);
                        if (addOnCache.ContainsKey(addOnId))
                        {
                            addOnCache[addOnId].Available = false;
                        }
                    }
                }

                CFingerprintCache.Rebuild(addOnCache);

                lock (sAddOnCache)
                {
                    sAddOnCache = addOnCache;
                }
            }
            //UpdateExceptionCache();
            GC.Collect();

        }

        /*
        private static void UpdateExceptionCache()
        {
            List<AddOnFingerprintException> exceptions = new List<AddOnFingerprintException>();

            using (SqlConnection conn = new SqlConnection(sAddonDatabaseConnection))
            {
                try
                {
                    conn.Open();
                }
                catch (Exception)
                {
                    Logger.Log(ELogLevel.Info, "localhost", "Unable to establish connection to database:" + DateTime.Now.ToString());
                    return;
                }

                SqlCommand command = conn.CreateCommand();
                command.CommandText = "select ProjectId, FilePath from curse_ProjectFingerprintException";

                using (SqlDataReader reader = command.ExecuteReader())
                {
                    while (reader.Read())
                    {
                        exceptions.Add(new AddOnFingerprintException(reader));
                    }
                }

            }


            lock (sExceptionFeedBytes)
            {
                sExceptionFeedBytes = AddOnFingerprintException.GetSerializedList(exceptions);
            }
        }
        */

    }
}
