﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Curse.ClientService.AddOns
{
    public class CFuzzyMatch
    {        
        private CAddOn mAddon = null;
        private CAddOnFile mAddonFile = null;        
        private List<long> mFingerprints;

        public List<long> Fingerprints
        {
            get
            {
                return mFingerprints;
            }
        }

        public int Id
        {
            get
            {
                return mAddon.Id;
            }
        }

        private bool IsFuzzyMatch(long s)
        {
            return mFingerprints.BinarySearch(s) >= 0;
        }

        public int FuzzyMatchCount(List<long> pFingerprints)
        {
            return pFingerprints.FindAll(IsFuzzyMatch).Count;
        }        

        public CFuzzyMatch(string pFolderName, CAddOn pAddOn, CAddOnFile pAddOnFile)
        {
            mAddon = pAddOn;
            mAddonFile = pAddOnFile;
            mFingerprints = pAddOnFile.FolderFingerprints[pFolderName];            
        }
    }
}
