﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.Text;
using Curse.ClientService.com.curse.auth;
using Curse.ClientService.Models;
using System.ServiceModel.Activation;

namespace Curse.ClientService
{ 
    [ServiceBehavior(Name = "CClientRegistrationService",
        Namespace = "http://clientservice.curse.com/",
        AddressFilterMode = AddressFilterMode.Any,
        ConcurrencyMode = ConcurrencyMode.Multiple,
        InstanceContextMode = InstanceContextMode.Single)]    
    public class CClientRegistrationService : IClientRegistrationService
    {


        public DateTime GetCacheFileDate(ECacheFileType type)
        {
            switch (type)
            {
                case ECacheFileType.GameCache:
                    return CGameCache.Instance.FileDate;

                case ECacheFileType.CategoryCache:
                    return CCategoryCache.Instance.FileDate;

                default:
                    return DateTime.UtcNow.AddYears(-1);
            }
        }     

        public bool IsUsernameAvailable(string username)
        {
            return CClientAuthentication.IsUsernameAvailable(username);            
        }

        public CRegisterUserResult RegisterUser(string username,
            string password,
            string firstname,
            string lastname,
            string birthdate,
            string gender,
            string country,
            string region,
            string city,
            string email,
            bool newsletter)
        {
            return CClientAuthentication.RegisterUser(username, password, firstname, lastname, birthdate, gender, country, region, city, email, newsletter);
        }
        
    }
}
