﻿using System;
using System.IdentityModel.Selectors;
using System.IdentityModel.Tokens;
using System.ServiceModel;

using Curse.ClientService.com.curse.auth;
using System.Collections.Generic;


namespace Curse.ClientService
{
    public class CValidator : UserNamePasswordValidator
    {
        
        public override void Validate(string userName, string password)
        {       
            ELoginStatus status = CClientAuthentication.AuthenticateUser(userName, password);
            if (status != ELoginStatus.Success)
            {
                var subCode = new FaultCode("FailedAuthentication");
                var faultCode = FaultCode.CreateSenderFaultCode(subCode);
                int statusCode = (int)status;
                var faultReason = new FaultReason(statusCode.ToString());
                throw new FaultException(faultReason, subCode);
            }
        }
    }
}
