﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Data.SqlClient;
using Curse.AddOns;
using System.Data;
using Curse.ClientService.Extensions;

namespace Curse.ClientService
{
    public class CAuthorCache
    {
        private static readonly CAuthorCache _instance;

        public static CAuthorCache Instance
        {
            get
            {
                return _instance;
            }
        }

        static CAuthorCache()
        {
            _instance = new CAuthorCache();
        }

        public Dictionary<int, List<CAddOnAuthor>> GetAuthorCache(SqlConnection conn, DateTime changeDate)
        {
            Dictionary<int, List<CAddOnAuthor>> authorCache = new Dictionary<int, List<CAddOnAuthor>>();                    

            using (SqlCommand authorCommand = new SqlCommand("curseService_GetAllAuthors", conn))
            {
                authorCommand.CommandType = CommandType.StoredProcedure;
                authorCommand.Parameters.Add(new SqlParameter("@LastUpdated", SqlDbType.DateTime));
                authorCommand.Parameters["@LastUpdated"].Value = changeDate;
                authorCommand.CommandTimeout = 300;

                using (SqlDataReader authorReader = authorCommand.ExecuteReader())
                {
                    while (authorReader.Read())
                    {
                        int projectID = authorReader.GetInt32(0);
                        string username = authorReader.GetString(1);

                        if (!authorCache.ContainsKey(projectID))
                        {
                            authorCache.Add(projectID, new List<CAddOnAuthor>());
                        }
                        CAddOnAuthor author = new CAddOnAuthor();
                        author.Name = username;
                        author.Url = author.GetAuthorUrl(username);
                        authorCache[projectID].Add(author);
                    }
                }
            }
            return authorCache;
        }
        
    }
}
