﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

using Curse.AddOns;
using Curse.Extensions;
using System.Data.SqlClient;
using System.Configuration;

namespace Curse.ClientService.Extensions
{
    public static class CAddOnCategoryExtension
    {
        private readonly static string sCategoryBaseUrl = null;

        static CAddOnCategoryExtension()
        {            
            sCategoryBaseUrl = ConfigurationManager.AppSettings["CategoryBaseUrl"];           
        }   

        public static void SetFromDataReader(this CAddOnCategory value, SqlDataReader reader)
        {
            value.Id = (int)reader["addon_category_id"];
            value.Name = (string)reader["addon_category_name"];
            value.URL = sCategoryBaseUrl.FormatWith((string)reader["addon_section"], (string)reader["addon_game_slug"], (string)reader["addon_category_slug"]);
        }
    }
}
