﻿using System;
using Curse.AddOns;
using Curse.Extensions;
using System.Data.SqlClient;
using System.Configuration;
using System.Drawing;
using System.Web;
using System.Net;

namespace Curse.ClientService.Extensions
{
    public static class CAvatarExtension
    {
        private static readonly string _iconMediaUrl;

        static CAvatarExtension() {
            _iconMediaUrl = ConfigurationManager.AppSettings["IconMediaUrl"];
        }//construct

        public static void SetFromDataReader(this CAvatar avatar, SqlDataReader pReader)
        {
            avatar.Id = (int)pReader["Id"];
            avatar.FileName = (string)pReader["FileName"];
            avatar.Width = (int)pReader["Width"];
            avatar.Height = (int)pReader["Height"];
            avatar.FileLength = (long)pReader["FileLength"];
            avatar.Status = (EAvatarStatus)pReader.GetByte(pReader.GetOrdinal("Status"));
            avatar.FilePath = string.Format(_iconMediaUrl, avatar.Id.ToModPath(), avatar.FileName);
        }// set from data reader
    }//class
}//namespace