﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Curse.AddOns;
using System.Data.SqlClient;
using System.Data;
using Curse.Extensions;
using System.Configuration;
using System.Drawing;
using System.IO;

namespace Curse.ClientService.Extensions
{
    public static class CGameExtension
    {

        public static void SetFromDataReader(this CGame game, SqlConnection pConn, SqlDataReader pReader)
        {
            // Primary Data
            game.ID = (int)pReader["GameId"];
            game.Name = (string)pReader["Name"];
            game.StageName = (string)pReader["StageName"];
            game.ExecutableFilename = (string)pReader["ExecutableFilename"];
            game.LauncherFilename = (string)pReader["LauncherFilename"];
            game.AddOnPath = (string)pReader["AddOnPath"];
            game.ProfilerAddOnId = (int)pReader["ProfilerAddOnId"];
            game.InitialInclusionPattern = (string)pReader["InitialInclusionPattern"];
            if (pReader["ExtraIncludePattern"] != System.DBNull.Value)
            {
                game.ExtraIncludePattern = (string)pReader["ExtraIncludePattern"];
            }
            game.DateModified = (DateTime)pReader["DateModified"];

            if (pReader["AddOnSettingsStartingFolder"] != System.DBNull.Value)
            {
                game.AddOnSettingsStartingFolder = (string)pReader["AddOnSettingsStartingFolder"];
                game.AddOnSettingsFolderFilter = (string)pReader["AddOnSettingsFolderFilter"];
                game.AddOnSettingsFileFilter = (string)pReader["AddOnSettingsFileFilter"];
            }
            //game.PackageType = (EPackageType)pReader["AddOnPackageType"];
            var gameResourcePath = ConfigurationManager.AppSettings["GameResourcePath"];

            try
            {
                if (pReader["AvatarID"] != System.DBNull.Value)
                {
                    int avatarID = (int)pReader["AvatarID"];
                    CAvatar avatar = CAvatarCache.Instance.Avatars.FirstOrDefault(p => p.Id == avatarID);
                    if (avatar != null)
                    {
                        game.Icon = avatar.Icon;
                    }
                }
            }
            catch (Exception exc)
            {
                Logger.Log("Failed to set game icon. Details: {0}", ELogLevel.Error, exc.GetExceptionDetails());
            }

            // Category Section
            try
            {
                game.CategorySections = CCategorySectionCache.Instance.GetAllSectionsByGameID(game.ID);
            }
            catch (Exception exc)
            {
                Logger.Log("Failed to get category sections. Details: {0}", ELogLevel.Error, exc.GetExceptionDetails());
            }

            #region File Parsing Rules
            SqlCommand command = new SqlCommand("spGetFileParsingRules", pConn);
            command.CommandType = CommandType.StoredProcedure;
            command.Parameters.Add(new SqlParameter("@intGameId", SqlDbType.Int));
            command.Parameters["@intGameId"].Value = game.ID;

            using (SqlDataReader reader = command.ExecuteReader())
            {
                while (reader.Read())
                {
                    CFileParsingRule rule = new CFileParsingRule();

                    rule.FileExtension = (string)reader["FileExtension"];
                    rule.InclusionPattern = (string)reader["InclusionPattern"];
                    if (reader["CommentStripPattern"] != System.DBNull.Value)
                    {
                        rule.CommentStripPattern = (string)reader["CommentStripPattern"];
                    }
                    game.FileParsingRules.Add(rule);
                }
            }
            #endregion

            #region Game Detection Hints
            command = new SqlCommand("spGetGameDetectionHints", pConn);
            command.CommandType = CommandType.StoredProcedure;
            command.Parameters.Add(new SqlParameter("@intGameId", SqlDbType.Int));
            command.Parameters["@intGameId"].Value = game.ID;

            using (SqlDataReader reader = command.ExecuteReader())
            {
                while (reader.Read())
                {
                    CGameDetectionHint hint = new CGameDetectionHint();
                    hint.SetFromDataReader(reader);
                    game.GameDetectionHints.Add(hint);
                }
            }
            #endregion

            #region Radon Calls
            using (var conn = new SqlConnection(ConfigurationManager.ConnectionStrings["RoamingDBRadon"].ConnectionString))
            {
                #region Exceptions
                command = new SqlCommand("curseService_GetExcludedPaths", conn);
                command.CommandType = CommandType.StoredProcedure;
                command.Parameters.Add(new SqlParameter("@intGameId", SqlDbType.Int));
                command.Parameters["@intGameId"].Value = game.ID;

                conn.Open();
                using (SqlDataReader reader = command.ExecuteReader())
                {
                    while (reader.Read())
                    {
                        game.ExcludedPaths.Add((string)reader["FilePath"]);
                    }
                }
                #endregion                
            }
            #endregion

            #region Saved Game Rules
            command = new SqlCommand("spGetGameSavedGameRules", pConn);
            command.CommandType = CommandType.StoredProcedure;
            command.Parameters.Add("@intGameId", SqlDbType.Int).Value = game.ID;
             
            using (var reader = command.ExecuteReader())
            {
                game.SyncSavedGames = reader.Read();

                if (game.SyncSavedGames)
                {
                    game.SavedGameFolder = reader.GetNullableValue<string>("FolderName");
                    game.SavedGameScanType = (ESavedGameScanType)reader.GetByte(reader.GetOrdinal("ScanType"));
                    game.SavedGameScanInterval = reader.GetInt64(reader.GetOrdinal("ScanInterval"));
                    game.SavedGameFilter = reader.GetNullableValue<string>("FileFilter");
                    game.MaxFileSize = reader.GetNullableValue<Int64>("MaxFileSize");
                    game.MaxFreeStorage = reader.GetInt64(reader.GetOrdinal("MaxFreeStorage"));
                    game.MaxPremiumStorage = reader.GetInt64(reader.GetOrdinal("MaxPremiumStorage"));
                }
            }
            #endregion

            #region GameResources
            command = new SqlCommand("SELECT * FROM GameResource WHERE GameID = @ID", pConn);
            command.Parameters.Add("ID", SqlDbType.Int).Value = game.ID;
            using (var reader = command.ExecuteReader())
            {
                // instantiate our list if we have resources
                if (reader.HasRows)
                {
                    game.Resources = new List<CGameResource>();
                }

                while (reader.Read())
                {
                    var resource = new CGameResource
                    {
                        ID = reader.GetInt32(reader.GetOrdinal("ID")),
                        GameID = reader.GetInt32(reader.GetOrdinal("GameID")),
                        Title = reader.GetString(reader.GetOrdinal("Title")),
                        Url = reader.GetString(reader.GetOrdinal("Url")),
                        SortOrder = reader.GetInt32(reader.GetOrdinal("SortOrder"))
                    };

                    game.Resources.Add(resource);
                }
            }
            #endregion

            #region Game Ui Options
            command = new SqlCommand("SELECT * FROM GameUiOptions WHERE GameID = @ID", pConn);
            command.Parameters.Add("ID", SqlDbType.Int).Value = game.ID;
            using (var reader = command.ExecuteReader())
            {
                if (reader.Read())
                {
                    game.GameUiOptions = new CGameUiOptions
                    {
                        GameResourceHeader = reader.GetNullableValue<string>("Header"),
                        MyContentText = reader.GetNullableValue<string>("MyContentText"),
                        GetMoreText = reader.GetNullableValue<string>("GetMoreText"),
                        ShowPlayButton = reader.GetBoolean(reader.GetOrdinal("ShowPlayButton"))
                    };

                    // This needs some work to make it not lock the resource
                    var logo = reader.GetNullableValue<string>("Logo");
                    if (!string.IsNullOrEmpty(logo) && File.Exists(gameResourcePath + logo))
                    {
                        game.GameUiOptions.Logo = new Bitmap(gameResourcePath + logo);
                    }

                    // This needs some work to make it not lock the resource
                    var backgroundImage = reader.GetNullableValue<string>("BackgroundImage");
                    if (!string.IsNullOrEmpty(backgroundImage) && File.Exists(gameResourcePath + backgroundImage))
                    {
                        game.GameUiOptions.Background = new Bitmap(gameResourcePath + backgroundImage);
                    }
                }
            }
            #endregion

            #region Game Features
            command = new SqlCommand("SELECT * FROM GameFeatures WHERE GameID = @ID", pConn);
            command.Parameters.Add("ID", SqlDbType.Int).Value = game.ID;
            game.GameFeatures = new CGameFeatures();
            using (var reader = command.ExecuteReader())
            {
                if (reader.Read())
                {
                    game.GameFeatures.Mods = reader.GetBoolean(reader.GetOrdinal("Mods"));
                    game.GameFeatures.ServerBrowser = reader.GetBoolean(reader.GetOrdinal("Serverbrowser"));
                    game.GameFeatures.GetMoreMods = reader.GetBoolean(reader.GetOrdinal("GetMoreMods"));
                    game.GameFeatures.SavedGameSync = reader.GetBoolean(reader.GetOrdinal("SavedGameSync"));
                }
            }
            #endregion            
        }
    }
}
