﻿using System;
using System.Data;
using Curse.ClientService.Models;
using System.Data.SqlClient;
using System.Configuration;
using Curse.Extensions;
using System.IO;

namespace Curse.ClientService.Extensions
{
    public static class CSavedGameRevisionExtension
    {
        static string _databaseConnectionString;
        static string _downloadUrl;

        static CSavedGameRevisionExtension()
        {
            _databaseConnectionString = ConfigurationManager.ConnectionStrings["ClientService"].ConnectionString;
            _downloadUrl = ConfigurationManager.AppSettings["SavedGameBaseUrl"];
        }

        public static void SetFromDataReader(this CSavedGameRevision revision, SqlDataReader reader)
        {
            revision.ID = reader.GetInt32(reader.GetOrdinal("ID"));
            revision.SavedGameID = reader.GetInt32(reader.GetOrdinal("SavedGameID"));
            revision.ComputerName = reader.GetString(reader.GetOrdinal("ComputerName"));
            revision.FileSize = reader.GetInt64(reader.GetOrdinal("FileSize"));
            revision.Fingerprint = reader.GetInt64(reader.GetOrdinal("Fingerprint"));
            revision.DateCreated = reader.GetDateTime(reader.GetOrdinal("DateCreated"));
            revision.Status = (ESavedGameRevisionStatus)reader.GetByte(reader.GetOrdinal("Status"));

            var userId = (int)reader["UserID"];
            revision.DownloadUrl = _downloadUrl.FormatWith(userId.ToFullModPath(), reader["GameID"], revision.ID); ;
        }

        public static void SetFavoriteRevision(this CSavedGameRevision revision)
        {
            using (var conn = new SqlConnection(_databaseConnectionString))
            {
                var cmd = new SqlCommand("UPDATE SavedGameRevision SET IsFavorite = 1 WHERE ID = @ID", conn);
                cmd.Parameters.Add("ID", SqlDbType.Int).Value = revision.ID;

                conn.Open();
                cmd.ExecuteNonQuery();
            }
        }

        public static void Save(this CSavedGameRevision revision)
        {
            if (revision.ID != 0)
            { //we don't save over only replace
                return;
            }

            using (var conn = new SqlConnection(_databaseConnectionString))
            {
                var cmd = conn.CreateCommand();
                cmd.CommandType = CommandType.StoredProcedure;
                cmd.CommandText = "spCreateSavedGameRevision";

                cmd.Parameters.Add("ID", SqlDbType.Int).Value = DBNull.Value;
                cmd.Parameters["ID"].Direction = ParameterDirection.InputOutput;

                cmd.Parameters.Add("SavedGameID", SqlDbType.Int).Value = revision.SavedGameID;
                cmd.Parameters.Add("ComputerName", SqlDbType.VarChar).Value = revision.ComputerName;
                cmd.Parameters.Add("FileSize", SqlDbType.BigInt).Value = revision.FileSize;
                cmd.Parameters.Add("Fingerprint", SqlDbType.BigInt).Value = revision.Fingerprint;
                cmd.Parameters.Add("MaxRevisionCount", SqlDbType.Int).Value = 0;

                conn.Open();
                cmd.ExecuteNonQuery();

                revision.ID = (int)cmd.Parameters["ID"].Value;
            }
        }

        public static void SoftDelete(this CSavedGameRevision revision)
        {
            using (var conn = new SqlConnection(_databaseConnectionString))
            {
                var cmd = new SqlCommand("spSoftDeleteSavedGameRevision", conn);
                cmd.CommandType = CommandType.StoredProcedure;
                cmd.Parameters.Add("ID", SqlDbType.Int).Value = revision.ID;

                conn.Open();
                cmd.ExecuteNonQuery();
            }
        }

        public static void HardDelete(this CSavedGameRevision revision)
        {
            using (var conn = new SqlConnection(_databaseConnectionString))
            {
                var cmd = new SqlCommand("spDeleteSavedGameRevision", conn);
                cmd.CommandType = CommandType.StoredProcedure;
                cmd.Parameters.Add("ID", SqlDbType.Int).Value = revision.ID;

                conn.Open();
                cmd.ExecuteNonQuery();
            }
        }
    }
}