﻿using System.Data.SqlClient;
using Curse.CommunityTracker.Models;

namespace Curse.CommunityTracker.Extensions
{
    public static class ApplicationActivityReportingExtensions
    {
        public static void SetFromDataReader(this ApplicationActivityReporting report, SqlDataReader reader)
        {
            report.ID = reader.GetInt32(reader.GetOrdinal("ID"));
            report.DateCreated = reader.GetDateTime(reader.GetOrdinal("DateCreated"));
            report.DateModified = reader.GetDateTime(reader.GetOrdinal("DateModified"));
            report.HostName = reader.GetString(reader.GetOrdinal("HostName"));
            report.ReportedActivity = reader.GetString(reader.GetOrdinal("ReportedActivity"));
            report.ReportingApplication = reader.GetString(reader.GetOrdinal("ReportingApplication"));
        }
    }
}