﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Curse.CommunityTracker.Models;
using System.Data.SqlClient;

namespace Curse.CommunityTracker.Extensions {
    public static class CAuthorExtensions {
        public static void SetFromDataReader(this CAuthor author, SqlDataReader reader) {
            author.ID = reader.GetInt32(reader.GetOrdinal("ID"));
            author.DataSourceID = reader.GetInt32(reader.GetOrdinal("CommunityDataSourceID"));
            author.Name = reader.GetString(reader.GetOrdinal("Name"));
            author.AvatarUrl = reader.GetNullbaleValue<string>("AvatarUrl");
            author.Type = (AuthorType)reader.GetByte(reader.GetOrdinal("Type"));
            author.Title = reader.GetNullbaleValue<string>("Title");
        }
    }
}