﻿using System;
using Curse.CommunityTracker.Models;
using System.Data.SqlClient;

namespace Curse.CommunityTracker.Extensions {
    public static class CForumExtension {
        public static void SetFromDataReader(this CForum forum, SqlDataReader reader) {
            forum.ID = reader.GetInt32(reader.GetOrdinal("ID"));
            forum.ParentForumID = reader.GetNullbaleValue<int?>("ParentForumID");
            forum.DataSourceID = reader.GetInt32(reader.GetOrdinal("CommunityDataSourceID"));
            forum.Title = reader.GetString(reader.GetOrdinal("Title"));
            forum.Description = reader.GetNullbaleValue<string>("Description");
            forum.Url = reader.GetString(reader.GetOrdinal("Url"));
            forum.Pages = reader.GetInt32(reader.GetOrdinal("Pages"));
            forum.Status = (CForumStatus)reader.GetByte(reader.GetOrdinal("Status"));
            forum.LastRunTimeUtc = reader.GetNullbaleValue<DateTime>("LastRunTimeUTC");
            forum.DateCreated = reader.GetDateTime(reader.GetOrdinal("DateCreated"));
            forum.DateModified = reader.GetDateTime(reader.GetOrdinal("DateModified"));
            forum.Slug = reader.GetString(reader.GetOrdinal("Slug"));
            forum.LanguageCode = reader.GetString(reader.GetOrdinal("LanguageCode"));
        }
    }
}