﻿using System;
using Curse.CommunityTracker.Models;
using System.Data.SqlClient;
using Curse.CommunityTracker.Extensions;
using Curse.CommunityTracker.Caching;

namespace Curse.CommunityTracker.Extensions {
    public static class CForumThreadPostExtension {
        public static void SetFromDataReader(this CForumThreadPost post, SqlDataReader reader) {
            post.ID = reader.GetInt32(reader.GetOrdinal("ID"));
            post.ThreadID = reader.GetInt32(reader.GetOrdinal("CommunityForumThreadID"));
            post.AuthorID = reader.GetInt32(reader.GetOrdinal("CommunityAuthorID"));
            post.Author = reader.GetString(reader.GetOrdinal("Author"));
            post.Avatar = reader.GetNullbaleValue<string>("Avatar");
            post.PostNumber = reader.GetInt32(reader.GetOrdinal("PostNumber"));
            post.Post = reader.GetString(reader.GetOrdinal("Post"));
            post.DatePosted = reader.GetDateTime(reader.GetOrdinal("DatePosted"));
            post.DatePostedEpoch = post.DatePosted.ToEpochTime();
            post.PostType = (PostType)reader.GetByte(reader.GetOrdinal("Type"));
            post.Url = reader.GetString(reader.GetOrdinal("Url"));
            post.DateCreated = reader.GetDateTime(reader.GetOrdinal("DateCreated"));
            post.DateModified = reader.GetDateTime(reader.GetOrdinal("DateModified"));
            post.PageNumber = reader.GetInt32(reader.GetOrdinal("PageNumber"));
            post.ParentCommentID = reader.GetNullbaleValue<int?>("ParentCommentID");
            var author = CAuthorCache.Instance.GetAuthorByID(post.AuthorID);
            if (author != null) {
                post.CommunityAuthor = author;
            }
        }
    }
}