﻿using System;
using System.Data.SqlClient;
using Curse.CommunityTracker.Models;

namespace Curse.CommunityTracker.Extensions
{
    public static class DataSourceHostExtentions
    {
        public static void SetFromDataReader(this DataSource dataSourceHost, SqlDataReader reader)
        {
            dataSourceHost.ID = reader.GetInt32(reader.GetOrdinal("ID"));
            dataSourceHost.Name = reader.GetString(reader.GetOrdinal("Name"));
            dataSourceHost.LastRunTimeUtc = reader.GetNullbaleValue<DateTime>("LastRunTimeUTC");
            dataSourceHost.Status = (ForumDataSourceStatus)reader.GetByte(reader.GetOrdinal("Status"));
            dataSourceHost.HostName = reader.GetString(reader.GetOrdinal("HostName"));
        }
    }
}