﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Curse.CommunityTracker.Extensions {
    public static class DateTimeExtensions {
        public static DateTime ToDateTime(this long epochTime) {
            var startDate = new DateTime(1970, 1, 1, 0, 0, 0, DateTimeKind.Utc);
            return startDate.AddSeconds(epochTime);
        }

        public static long ToEpochTime(this DateTime date) {
            var epoch = new DateTime(1970, 1, 1, 0, 0, 0, DateTimeKind.Utc);
            return Convert.ToInt64((date - epoch).TotalSeconds);
        }
    }
}