﻿using System.Data.SqlClient;
using Curse.CommunityTracker.Models;

namespace Curse.CommunityTracker.Extensions
{
    public static class ELMAH_ErrorExtensions
    {
        public static void SetFromDataReader(this ELMAH_Error error, SqlDataReader reader)
        {
            error.ErrorId = reader.GetGuid(reader.GetOrdinal("ErrorId"));
            error.Application = reader.GetString(reader.GetOrdinal("Application"));
            error.Host = reader.GetString(reader.GetOrdinal("Host"));
            error.Type = reader.GetString(reader.GetOrdinal("Type"));
            error.Source = reader.GetString(reader.GetOrdinal("Source"));
            error.Message = reader.GetString(reader.GetOrdinal("Message"));
            error.User = reader.GetString(reader.GetOrdinal("User"));
            error.StatusCode = reader.GetInt32(reader.GetOrdinal("StatusCode"));
            error.TimeUtc = reader.GetDateTime(reader.GetOrdinal("TimeUtc"));
            error.Sequence = reader.GetInt32(reader.GetOrdinal("Sequence"));
            error.AllXml = reader.GetString(reader.GetOrdinal("AllXml"));
        }
    }
}