﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.SessionState;
using System.Configuration;
using System.Web.Hosting;

namespace Curse.CommunityTracker
{
    public class Global : System.Web.HttpApplication
    {

        protected void Application_Start(object sender, EventArgs e)
        {
#if DEBUG
            Logger.SetLogLevel = ELogLevel.Debug;
#else
            Logger.SetLogLevel = ELogLevel.Error;
#endif
            Logger.SetLogPath = ConfigurationManager.AppSettings["LogPath"];

            Logger.Log("Application Starting", ELogLevel.Info);
        }

        protected void Session_Start(object sender, EventArgs e)
        {

        }

        protected void Application_BeginRequest(object sender, EventArgs e)
        {

        }

        protected void Application_AuthenticateRequest(object sender, EventArgs e)
        {

        }

        protected void Application_Error(object sender, EventArgs e)
        {

        }

        protected void Session_End(object sender, EventArgs e)
        {

        }

        protected void Application_End(object sender, EventArgs e)
        {
            Logger.Log("Application Ended", ELogLevel.Info);
            try
            {
                ApplicationShutdownReason shutdownReason = HostingEnvironment.ShutdownReason;
                Logger.Log("Application Shutdown Reason: " + shutdownReason.ToString(), ELogLevel.Info);
            }
            catch (Exception ex)
            {
                Logger.Log("Unable to determine shutdown reason: " + ex.Message, ELogLevel.Info);
            }     
        }
    }
}