﻿using System.ServiceModel;
using System.ServiceModel.Web;
using Curse.CommunityTracker.Models;

namespace Curse.CommunityTracker {
    [ServiceContract]
    public interface ICommunityTracker 
    {        

        [OperationContract]
        [WebGet]
        ForumDataSource[] GetAllDataSources();

        [OperationContract]
        [WebGet]
        ForumDataSource[] GetDataSourceByGameId(int id);

        [OperationContract]
        [WebGet]
        ForumDataSource[] GetDataSourceByLanguage(int gameId, string language);

        [OperationContract]
        [WebGet]
        CForum[] GetForumsBySourceId(int id);

        [OperationContract]
        [WebGet]
        CForumThread[] GetThreadsByForumId(int id, long since);        

        [OperationContract]
        [WebGet]
        CForumThreadPost[] GetPostsByThreadId(int id, long since);

        [OperationContract(Name="GetAllSourceActivitySince")]
        [WebGet]
        UpdatedThread[] GetAllActivitySince(int dataSourceId, long since);
        
        [OperationContract(Name="GetAllActivitySince")]
        [WebGet]
        UpdatedThread[] GetAllActivitySince(int[] dataSourceIds, long since);

        [OperationContract(Name = "GetAllActivitySinceFull")]
        [WebGet]
        DataSourceActivity[] GetAllActivitySinceFull(int[] dataSourceIds, long since);

        [OperationContract]
        [WebGet]
        CAuthor[] GetAuthorsByDataSourceId(int id, long since);

        [OperationContract(Name = "GetElmahErrorsByHost")]
        [WebGet]
        ELMAH_Error[] GetElmahErrorsByHost(string host);

        [OperationContract(Name = "GetAllHostsWithDataSourceList")]
        [WebGet]
        HostList[] GetAllHostsWithDataSourceList();

        [OperationContract(Name = "ChangeDataSourceHost")]
        [WebGet]
        bool ChangeDataSourceHost(int id, string host);

        [OperationContract(Name = "GetCpuMonitorByHostLastX")]
        [WebGet]
        CpuMonitor[] GetCpuMonitorByHostLastX(string host, int rowsToGet);

        [OperationContract(Name = "GetPostByDataSourceId")]
        [WebGet]
        CForumThreadPost[] GetPostByDataSourceId(int id, int rowsToGet);
    }
}
