﻿using System;
using System.Runtime.Serialization;
using Curse.CommunityTracker.Caching;

namespace Curse.CommunityTracker.Models {
    
    public enum CForumStatus 
    {
        Active = 1,
        Inactive,
        TemporarilyInactive
    }
    
    [DataContract(Name = "cforum")]
    public class CForum {
        [DataMember(Name = "id")]
        public int ID { get; set; }

        [DataMember(Name = "parentForumid")]
        public int? ParentForumID { get; set; }

        [DataMember(Name = "parentForumUrl")]
        public string ParentForumUrl 
        {
            get
            {
                if (!ParentForumID.HasValue)
                {
                    return null;
                }

                CForum forum = CForumCache.Instance.GetForumByID(this.ParentForumID.Value);
                if (forum != null)
                {
                    return forum.Url;
                }
                else
                {
                    return null;
                }
            }
            set
            {
            }
        }


        [DataMember(Name = "dataSourceId")]
        public int DataSourceID { get; set; }

        [DataMember(Name = "title")]
        public string Title { get; set; }

        [DataMember(Name = "description")]
        public string Description { get; set; }

        [DataMember(Name = "url")]
        public string Url { get; set; }

        [DataMember(Name = "pages")]
        public int Pages { get; set; }

        [DataMember(Name = "status")]
        public CForumStatus Status { get; set; }

        [DataMember(Name = "lastRunTimeUtc")]
        public DateTime LastRunTimeUtc { get; set; }

        [DataMember(Name = "dateCreated")]
        public DateTime DateCreated { get; set; }

        [DataMember(Name = "dateModified")]
        public DateTime DateModified { get; set; }

        [DataMember(Name = "slug")]
        public string Slug { get; set; }        

        [DataMember(Name = "languageCode")]
        public string LanguageCode { get; set; }
    }
}