﻿using System;
using System.Runtime.Serialization;

namespace Curse.CommunityTracker.Models {
    public enum PostType {
        AdminPost = 1,
        ModeratorPost,
        MvpPost,
        UserPost
    }
    
    [DataContract(Name = "cForumThreadPost")]
    public class CForumThreadPost {
        [DataMember(Name = "id")]
        public int ID { get; set; }
        
        [DataMember(Name = "threadId")]
        public int ThreadID { get; set; }

        [DataMember(Name = "authorId")]
        public int AuthorID { get; set; }
        
        [DataMember(Name = "author")]
        public string Author { get; set; }

        [DataMember(Name = "avatar")]
        public string Avatar { get; set; }

        [DataMember(Name = "communityAuthor")]
        public CAuthor CommunityAuthor { get; set; }

        [DataMember(Name = "postNumber")]
        public int PostNumber { get; set; }

        [DataMember(Name = "post")]
        public string Post { get; set; }

        [DataMember(Name = "datePosted")]
        public DateTime DatePosted { get; set; }

        [DataMember(Name = "datePostedEpoch")]
        public long DatePostedEpoch { get; set; }

        [DataMember(Name = "postType")]
        public PostType PostType { get; set; }

        [DataMember(Name = "url")]
        public string Url { get; set; }

        [DataMember(Name = "dateCreated")]
        public DateTime DateCreated { get; set; }

        [DataMember(Name = "dateModified")]
        public DateTime DateModified { get; set; }

        [DataMember(Name = "pageNumber")]
        public int PageNumber { get; set; }

        [DataMember(Name = "parentCommentId")]
        public int? ParentCommentID { get; set; }

    }
}