﻿using System.Net;
using System.Configuration;
using Curse.Logging;

namespace Curse.Billing.Configuration
{
    public static class VindiciaConfiguration
    {

        public static string Username { get; set; }
        public static string Password { get; set; }
        public static string EndpointUrl { get; set; }

        public static void Initialize()
        {
            Logger.Info("Vindicia Configuration Initializing...");

#if DEBUG
            ServicePointManager.ServerCertificateValidationCallback = delegate { return true; };
#endif
            
            Username = ConfigurationManager.AppSettings["VindiciaUsername"];
            Password = ConfigurationManager.AppSettings["VindiciaPassword"];
            EndpointUrl = ConfigurationManager.AppSettings["VindiciaEndpointUrl"];

            Vindicia.Environment.SetEndpoint(EndpointUrl);
            Vindicia.Environment.SetAuth(Username, Password);
                                    
            Logger.Info("Vindicia Configuration Initialized");
        }

    }
}
