﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Vindicia;
using System.Web.Caching;
using System.Web;
using Curse.Billing.Extensions;

namespace Curse.Billing.Data
{
    public static class Retrieval
    {

        public static Product GetProductByID(string id)
        {
            Product p = new Product();
            Return r = p.fetchByMerchantProductId(id);
            if (r.returnCode == ReturnCode.Item200)
            {
                return p;
            }
            else
            {
                return null;
            }
        }

        public static Product[] GetAllProducts()
        {
            Product b = new Product();
            List<Product> products = new List<Product>();
            int count = 0;
            int page = 0;
            int pageSize = 10;

            do
            {
                count = 0;
                Product[] fetchedAutoBills;
                b.fetchAll(page, true, pageSize, true, out fetchedAutoBills);
                if (fetchedAutoBills != null)
                {
                    count = fetchedAutoBills.Length;
                    products.AddRange(fetchedAutoBills);
                    ++page;
                }

            } while (count > 0);

            return products.ToArray();
        }

        public static Transaction GetTransactionByVid(string vid)
        {
            Transaction txn = new Transaction();
            Return r = txn.fetchByVid(vid);
            if (r.returnCode == ReturnCode.Item200)
            {
                return txn;
            }
            else
            {
                return null;
            }
        }

        public static Account GetAccountByID(string id)
        {
            Account a = new Account();            
            try
            {
                Return r = a.fetchByMerchantAccountId(id);
                if (r.returnCode == ReturnCode.Item200)
                {
                    return a;
                }
                else
                {
                    return null;
                }
            }
            catch
            {
                return null;
            }
        }



        public static BillingPlan[] GetAllBillingPlans()
        {                        
            BillingPlan b = new BillingPlan();
            List<BillingPlan> billingPlans = new List<BillingPlan>();
            int count = 0;
            int page = 0;
            int pageSize = 100;
            
            do
            {
                count = 0;
                BillingPlan[] fetchedPlans;
                b.fetchAll(page, true, pageSize, true, out fetchedPlans);
                if (fetchedPlans != null)
                {
                    count = fetchedPlans.Length;
                    billingPlans.AddRange(fetchedPlans);
                    ++page;
                }                
            } while (count > 0);

            return billingPlans.ToArray();                        
        }

        public static BillingPlan GetBillingPlanByID(string id)
        {
            BillingPlan b = new BillingPlan();            
            Return r = b.fetchByMerchantBillingPlanId(id);
            return b;
        }

        public static AutoBill GetAutoBillByVID(string vid)
        {
            AutoBill ab = new AutoBill();
            Return r = ab.fetchByVid(vid);
            return ab;
        }

        public static DateTime VindiciaNow
        {
            get
            {
                return DateTime.UtcNow.PrepareForVindicia();
            }
        }

        public static AutoBill[] GetAllAutoBillsByAccountID(string id)
        {
            Account a = new Account();
            a.merchantAccountId = id;
            AutoBill[] autoBills;
            AutoBill ab = new AutoBill();
            ab.fetchByAccount(a, out autoBills);
            return autoBills;
        }

        public static Entitlement[] GetAllEntitlementsByAccountID(string id, bool activeOnly)
        {
            Account a = new Account();
            a.merchantAccountId = id;

            Entitlement b = new Entitlement();
            Entitlement[] entitlements;
            b.fetchByAccount(a, !activeOnly, out entitlements);
            return entitlements;
        }

        public static Entitlement[] GetAllEntitlementsByAccountIDAndEntitlementIDs(string accountID, string[] entitlementIDs, bool activeOnly)
        {
            Entitlement[] entitlements = GetAllEntitlementsByAccountID(accountID, activeOnly);
            return entitlements.Where(p => entitlementIDs.Contains(p.merchantEntitlementId)).ToArray();
        }

        public static Entitlement[] GetAllEntitlementsFromDate(DateTime date)
        {            
            Entitlement b = new Entitlement();
            List<Entitlement> entitlements = new List<Entitlement>();
            int count = 0;
            int page = 0;
            int pageSize = 100;

            do
            {
                count = 0;
                Entitlement[] fetchedEntitlements;
                b.fetchDeltaSince(date, page, pageSize, VindiciaNow, true, out fetchedEntitlements);
                if (fetchedEntitlements != null)
                {
                    count = fetchedEntitlements.Length;
                    entitlements.AddRange(fetchedEntitlements);
                    ++page;                    
                }
                
            } while (count > 0);

            return entitlements.ToArray();
        }

        public static Transaction[] GetAllTransactionsFromDate(DateTime date)
        {
            Transaction b = new Transaction();
            List<Transaction> transactions = new List<Transaction>();
            int count = 0;
            int page = 0;
            int pageSize = 100;

            do
            {
                count = 0;
                Transaction[] fetchedTransactions;
                b.fetchDeltaSince(date, VindiciaNow, page, pageSize, null, out fetchedTransactions);
                if (fetchedTransactions != null)
                {
                    count = fetchedTransactions.Length;
                    transactions.AddRange(fetchedTransactions);
                    ++page;
                }

            } while (count > 0);

            return transactions.ToArray();
        }

        public static AutoBill[] GetAllAutoBillsFromDate(DateTime date)
        {
            AutoBill b = new AutoBill();            
            List<AutoBill> autoBills = new List<AutoBill>();
            int count = 0;
            int page = 0;
            int pageSize = 100;

            do
            {
                count = 0;
                AutoBill[] fetchedAutoBills;
                b.fetchDeltaSince(date, page, pageSize, VindiciaNow, true, out fetchedAutoBills);
                if (fetchedAutoBills != null)
                {
                    count = fetchedAutoBills.Length;
                    autoBills.AddRange(fetchedAutoBills);
                    ++page;
                }

            } while (count > 0);

            return autoBills.ToArray();
        }

        public static Token GetTokenByID(string id)
        {
            Token token = new Token();
            token.merchantTokenId = id;
            Return r = token.fetch();
            return token;
        }
    }
}
